/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element;

import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.element.ProductCategory;
import com.aliyun.migration.teleport.common.element.Vendor;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;

public enum BigDataProduct {
    SPARK("Apache Spark", ProductCategory.ProcessEngine, Vendor.Apache),
    HIVE("Apache Hive", ProductCategory.DataWarehouse, Vendor.Apache),
    FLINK("Apache Flink", ProductCategory.StreamEngine, Vendor.Apache),
    HDFS("Apache HDFS", ProductCategory.Storage, Vendor.Apache),
    S3("Amazon S3", ProductCategory.Storage, Vendor.Aws),
    OSS("Aliyun OSS", ProductCategory.Storage, Vendor.Aliyun),
    OSS_HDFS("Aliyun OSS-HDFS", ProductCategory.Storage, Vendor.Aliyun),
    REDSHIFT("Amazon Redshift", ProductCategory.DataWarehouse, Vendor.Aws),
    MAXCOMPUTE("MaxCompute", ProductCategory.DataWarehouse, Vendor.Aliyun),
    HOLOGRES("Hologres", ProductCategory.DataWarehouse, Vendor.Aliyun),
    STARROCKS("StarRocks", ProductCategory.OLAPEngine, Vendor.Apache),
    TRINO("Trino", ProductCategory.OLAPEngine, Vendor.Apache),
    PRESTO("Presto", ProductCategory.OLAPEngine, Vendor.Apache),
    DOLPHINSCHEDULER("DolphinScheduler", ProductCategory.Workflow, Vendor.Apache),
    AIRFLOW("Airflow", ProductCategory.Workflow, Vendor.Apache),
    OOZIE("Oozie", ProductCategory.Workflow, Vendor.Apache),
    AZKABAN("Azkaban", ProductCategory.Workflow, Vendor.LinkedIn),
    DATAARTSSTUDIO("DataArtsStudio", ProductCategory.Workflow, Vendor.Huawei),
    HUDI("Hudi", ProductCategory.Lake, Vendor.Apache),
    ICEBERG("Iceberg", ProductCategory.Lake, Vendor.Apache),
    DLF("DLF", ProductCategory.Catalog, Vendor.Aliyun),
    PAIMON("Paimon", ProductCategory.Lake, Vendor.Aliyun),
    DATAWORKS("DataWorks", ProductCategory.IDE, Vendor.Aliyun),
    ALLUXIO("Alluxio", ProductCategory.Cache, Vendor.Aliyun),
    HMS("HMS", ProductCategory.Catalog, Vendor.Aliyun),
    GLUE("AWS Glue", ProductCategory.Catalog, Vendor.Aws),
    UNITY_CATALOG("Databricks unity catalog", ProductCategory.Catalog, Vendor.Databricks),
    DELTALAKE("DeltaLake", ProductCategory.Lake, Vendor.Databricks),
    ADF("Azure DataFactory", ProductCategory.Workflow, Vendor.Azure),
    SYNAPSE("Azure Synapse", ProductCategory.OLAPEngine, Vendor.Azure),
    ADBPG("AnalyticDatabase for PG", ProductCategory.DataWarehouse, Vendor.Aliyun);

    private final String name;
    private final ProductCategory category;
    private final Vendor vendor;

    private BigDataProduct(String name, ProductCategory category, Vendor vendor) {
        this.name = name;
        this.category = category;
        this.vendor = vendor;
    }

    public String getName() {
        return this.name;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public static BigDataProduct of(String value) {
        for (BigDataProduct type : BigDataProduct.values()) {
            if (!type.name().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new TeleportException(TeleportStatusCode.BIZ_ERROR, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b:" + value);
    }
}

