/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.meta.data;

import com.aliyun.migration.teleport.common.element.meta.Version;
import java.io.Serializable;

public class MetaVersion
implements Serializable {
    private Long datasourceId;
    private Version metaVersion = Version.ofLatestCustomVersion();

    public MetaVersion(Long datasourceId, String version) {
        this.datasourceId = datasourceId;
        this.metaVersion = Version.of(version);
    }

    public static MetaVersion of(Long datasourceId, String version) {
        return new MetaVersion(datasourceId, version);
    }

    public static MetaVersion of(Long datasourceId, Version version) {
        return new MetaVersion(datasourceId, version.toString());
    }

    public static MetaVersion ofLatestBaseVersion(Long datasourceId) {
        return new MetaVersion(datasourceId, Version.ofLatestBaseVersion().toString());
    }

    public static MetaVersion ofLatestCustomVersion(Long datasourceId) {
        return new MetaVersion(datasourceId, Version.ofLatestCustomVersion().toString());
    }

    public static MetaVersion ofLatestUploadVersion(Long datasourceId) {
        return new MetaVersion(datasourceId, Version.ofLatestUploadVersion().toString());
    }

    public static MetaVersion ofLatestMigrationVersion(Long datasourceId) {
        return new MetaVersion(datasourceId, Version.ofLatestMigrationVersion().toString());
    }

    public Long getDatasourceId() {
        return this.datasourceId;
    }

    public Version getMetaVersion() {
        return this.metaVersion;
    }

    public void setDatasourceId(Long datasourceId) {
        this.datasourceId = datasourceId;
    }

    public void setMetaVersion(Version metaVersion) {
        this.metaVersion = metaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaVersion)) {
            return false;
        }
        MetaVersion other = (MetaVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$datasourceId = this.getDatasourceId();
        Long other$datasourceId = other.getDatasourceId();
        if (this$datasourceId == null ? other$datasourceId != null : !((Object)this$datasourceId).equals(other$datasourceId)) {
            return false;
        }
        Version this$metaVersion = this.getMetaVersion();
        Version other$metaVersion = other.getMetaVersion();
        return !(this$metaVersion == null ? other$metaVersion != null : !((Object)this$metaVersion).equals(other$metaVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $datasourceId = this.getDatasourceId();
        result = result * 59 + ($datasourceId == null ? 43 : ((Object)$datasourceId).hashCode());
        Version $metaVersion = this.getMetaVersion();
        result = result * 59 + ($metaVersion == null ? 43 : ((Object)$metaVersion).hashCode());
        return result;
    }

    public String toString() {
        return "MetaVersion(datasourceId=" + this.getDatasourceId() + ", metaVersion=" + String.valueOf(this.getMetaVersion()) + ")";
    }

    public MetaVersion() {
    }
}

