/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.agent.data;

import com.aliyun.migration.teleport.common.dto.meta.enums.JobStatus;
import java.io.Serializable;
import java.time.LocalDateTime;

public class DiscoveryJobResult
implements Serializable {
    private Long jobId;
    private JobStatus jobStatus;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String errorCode;
    private String errorMessage;
    private String metaVersion;
    private String tenantId;

    public static DiscoveryJobResult buildSuccess(Long jobId, LocalDateTime startTime, LocalDateTime endTime) {
        DiscoveryJobResult result = new DiscoveryJobResult();
        result.setJobId(jobId);
        result.setJobStatus(JobStatus.SUCCESS);
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        return result;
    }

    public static DiscoveryJobResult buildFailure(Long jobId, LocalDateTime startTime, LocalDateTime endTime, String errorMessage) {
        DiscoveryJobResult result = new DiscoveryJobResult();
        result.setJobId(jobId);
        result.setJobStatus(JobStatus.FAILED);
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setErrorMessage(errorMessage);
        return result;
    }

    public static DiscoveryJobResult buildCanceled(Long jobId, LocalDateTime startTime, LocalDateTime endTime) {
        DiscoveryJobResult result = new DiscoveryJobResult();
        result.setJobId(jobId);
        result.setJobStatus(JobStatus.CANCELED);
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        return result;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMetaVersion() {
        return this.metaVersion;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setMetaVersion(String metaVersion) {
        this.metaVersion = metaVersion;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscoveryJobResult)) {
            return false;
        }
        DiscoveryJobResult other = (DiscoveryJobResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobId = this.getJobId();
        Long other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$metaVersion = this.getMetaVersion();
        String other$metaVersion = other.getMetaVersion();
        if (this$metaVersion == null ? other$metaVersion != null : !this$metaVersion.equals(other$metaVersion)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiscoveryJobResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $metaVersion = this.getMetaVersion();
        result = result * 59 + ($metaVersion == null ? 43 : $metaVersion.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    public String toString() {
        return "DiscoveryJobResult(jobId=" + this.getJobId() + ", jobStatus=" + String.valueOf(this.getJobStatus()) + ", startTime=" + String.valueOf(this.getStartTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", metaVersion=" + this.getMetaVersion() + ", tenantId=" + this.getTenantId() + ")";
    }
}

