/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.model;

import com.alibaba.security.url.model.DomainMask;
import com.alibaba.security.url.model.SSRFMatcherMask;
import com.alibaba.security.url.model.SubnetMask;
import java.util.HashMap;
import java.util.Map;

public enum SSRFMatcherEnum {
    INTRANET_DOMAIN("intranet domain", true, DomainMask.class),
    INTRANET_IP("intranet ip", false, SubnetMask.class),
    INTRANET_IPV6("intranet ipv6", false, SubnetMask.class),
    EXCLUDED_DOMAIN("excluded domain", true, DomainMask.class),
    EXCLUDED_IP("excluded ip", false, SubnetMask.class),
    EXCLUDED_IPV6("excluded ipv6", false, SubnetMask.class),
    TRUSTED_DOMAIN("trusted domain", true, DomainMask.class),
    TRUSTED_IP("trusted ip", false, SubnetMask.class);

    private final String value;
    private final boolean isDomain;
    private Class<? extends SSRFMatcherMask> supportMaskType;
    private static final Map<String, SSRFMatcherEnum> stringToEnum;

    private SSRFMatcherEnum(String v, boolean isDomain, Class<? extends SSRFMatcherMask> supportMaskType) {
        this.value = v;
        this.isDomain = isDomain;
        this.supportMaskType = supportMaskType;
    }

    public String value() {
        return this.value;
    }

    public Class<? extends SSRFMatcherMask> supportMaskType() {
        return this.supportMaskType;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public static SSRFMatcherEnum fromValue(String v) {
        String value = SSRFMatcherEnum.emptyToNull(v);
        if (value == null) {
            return null;
        }
        if (stringToEnum.containsKey(v)) {
            return stringToEnum.get(v);
        }
        throw new IllegalArgumentException(v);
    }

    private static String emptyToNull(String string) {
        return string == null || string.length() == 0 ? null : string;
    }

    static {
        stringToEnum = new HashMap<String, SSRFMatcherEnum>();
        for (SSRFMatcherEnum item : SSRFMatcherEnum.values()) {
            if (stringToEnum.containsKey(item.value())) {
                throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.value());
            }
            stringToEnum.put(item.value(), item);
        }
    }
}

