/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.servlets.providers;

import com.alibaba.securitysdk.logging.api.servlets.ProfileProvider;
import com.alibaba.securitysdk.logging.api.servlets.profiles.HostInfo;
import com.alibaba.securitysdk.logging.api.servlets.profiles.ServerEndpoint;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;

public class ServerEndpointsProvider
implements ProfileProvider<List<ServerEndpoint>> {
    private final HostInfo hostInfo;

    public ServerEndpointsProvider(HostInfo hostInfo) {
        this.hostInfo = (HostInfo)AssertUtil.notNull((Object)hostInfo);
    }

    @Override
    public List<ServerEndpoint> provide() {
        ArrayList<ServerEndpoint> serverEndpoints = new ArrayList<ServerEndpoint>();
        if (this.hostInfo.getHostAddresses().isEmpty()) {
            return serverEndpoints;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objs = mbs.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            for (ObjectName obj : objs) {
                String scheme = mbs.getAttribute(obj, "scheme").toString();
                String port = obj.getKeyProperty("port");
                for (String hostAddress : this.hostInfo.getHostAddresses()) {
                    serverEndpoints.add(new ServerEndpoint(scheme, hostAddress, port));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverEndpoints;
    }
}

