/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.loggers;

import com.alibaba.securitysdk.logging.api.configurations.LogConfig;
import com.alibaba.securitysdk.logging.api.loggers.AbstractConfigurableLogger;
import com.alibaba.securitysdk.logging.utils.AssertUtil;

public abstract class LimitedConfigurableLogger
extends AbstractConfigurableLogger {
    private static final int DEFAULT_BUFFER_SIZE_KB = 4096;
    private static final int MINIMUM_LIMITED_SIZE_KB = 128;
    private int limitedSize;

    public LimitedConfigurableLogger(String name, LogConfig logConfig) {
        this(name, logConfig, 4096);
    }

    public LimitedConfigurableLogger(String name, LogConfig logConfig, int limitedSize) {
        super(name, logConfig);
        AssertUtil.checkArgument((limitedSize > 128 ? 1 : 0) != 0);
        this.limitedSize = limitedSize;
    }

    public int getLimitedSize() {
        return this.limitedSize;
    }
}

