/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.factories;

import com.alibaba.securitysdk.logging.api.Logger;
import com.alibaba.securitysdk.logging.api.binders.LoggerBinderSingleton;
import com.alibaba.securitysdk.logging.api.configurations.LogConfig;
import com.alibaba.securitysdk.logging.api.factories.ILoggerFactory;

public class LoggerManager {
    private static final String UNSUCCESSFUL_INIT_MSG = "LoggerFactory could not be successfully initialized.";
    private static volatile InitializationState INITIALIZATION_STATE = InitializationState.UNINITIALIZED;

    private LoggerManager() {
    }

    public static <T extends Logger> T getLogger(Class<T> clazz) {
        return LoggerManager.getLoggerFactory(clazz).getLogger(clazz.getSimpleName());
    }

    public static <T extends Logger> T getLogger(String name, Class<T> clazz) {
        return LoggerManager.getLoggerFactory(clazz).getLogger(name);
    }

    public static <T extends Logger> T getLogger(Class<T> clazz, LogConfig logConfig) {
        return LoggerManager.getLoggerFactory(clazz).getLogger(clazz.getSimpleName(), logConfig);
    }

    public static <T extends Logger> T getLogger(String name, LogConfig logConfig, Class<T> clazz) {
        return LoggerManager.getLoggerFactory(clazz).getLogger(name, logConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static <T extends Logger> ILoggerFactory<T> getLoggerFactory(Class<T> clazz) {
        if (INITIALIZATION_STATE == InitializationState.UNINITIALIZED) {
            Class<LoggerManager> clazz2 = LoggerManager.class;
            // MONITORENTER : com.alibaba.securitysdk.logging.api.factories.LoggerManager.class
            if (INITIALIZATION_STATE == InitializationState.UNINITIALIZED) {
                INITIALIZATION_STATE = InitializationState.ONGOING_INITIALIZATION;
                LoggerManager.performInitialization();
                INITIALIZATION_STATE = InitializationState.SUCCESSFUL_INITIALIZATION;
            }
            // MONITOREXIT : clazz2
        }
        switch (INITIALIZATION_STATE) {
            case SUCCESSFUL_INITIALIZATION: {
                return LoggerBinderSingleton.INSTANCE.getLoggerFactory(clazz);
            }
            case FAILED_INITIALIZATION: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    private static void performInitialization() {
        try {
            LoggerBinderSingleton.INSTANCE.performBindingAll();
        }
        catch (Exception ex) {
            INITIALIZATION_STATE = InitializationState.FAILED_INITIALIZATION;
        }
    }

    private static enum InitializationState {
        UNINITIALIZED,
        ONGOING_INITIALIZATION,
        FAILED_INITIALIZATION,
        SUCCESSFUL_INITIALIZATION;

    }
}

