/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SecType {
    CSRF("csrf"),
    XSS_ESCAPE("xss_escape_method"),
    SAFE_URL("safe_url"),
    JSONP("jsonp_injection"),
    JSON_ESCAPE("json_escape"),
    JSONP_ESCAPE("jsonp_escape"),
    JS_ESCAPE("js_escape"),
    XML_ESCAPE("xml_escape"),
    JSONP_FILTER("jsonp_filter"),
    COMMAND_INJECTION("command_injection"),
    RICHTEXT("rich_text"),
    PATH_FILTER("path_filter"),
    SQL_ESCAPE("sql_escape"),
    SQL_Trim("sql_trim"),
    URI_ESCAPE("uri_escape"),
    SSRF("ssrf"),
    SAFE_URL_OBSERVED("observed_safe_url"),
    SSRF_OBVSRVED("observed_ssrf");

    private static Map<SecType, String> SEC_TYPE_TOTAL_COUNT_STRING_MAP;
    private static Map<SecType, String> SEC_TYPE_PROTECTED_COUNT_STRING_MAP;
    private String typeName;

    static void setup() {
        HashMap<SecType, String> temp = new HashMap<SecType, String>();
        HashMap<SecType, String> temp2 = new HashMap<SecType, String>();
        for (SecType secType : EnumSet.allOf(SecType.class)) {
            temp.put(secType, secType.name() + " Total");
            temp2.put(secType, secType.name() + " Protected");
        }
        SEC_TYPE_TOTAL_COUNT_STRING_MAP = Collections.unmodifiableMap(temp);
        SEC_TYPE_PROTECTED_COUNT_STRING_MAP = Collections.unmodifiableMap(temp2);
    }

    private SecType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTotalName() {
        return SEC_TYPE_TOTAL_COUNT_STRING_MAP.get((Object)this);
    }

    public String getProtectedName() {
        return SEC_TYPE_PROTECTED_COUNT_STRING_MAP.get((Object)this);
    }

    static {
        SecType.setup();
    }
}

