/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.SqoopParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceHdfsParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceHiveParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceMysqlParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetHdfsParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetHiveParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetMysqlParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SqoopNodeConvert.class);

    public SqoopNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        SqoopParameters parameter = (SqoopParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(SqoopParameters.class).getType());
        DIJsonProcessor diProcessor = DIJsonProcessor.from((String)DIConfigTemplate.DI_CODE_TEMPLATE);
        DIJsonProcessor readerJp = diProcessor.getConfiguration("steps[0]");
        DIJsonProcessor writerJp = diProcessor.getConfiguration("steps[1]");
        this.processSqoopSource(parameter, readerJp);
        this.processSqoopTarget(parameter, writerJp);
        diProcessor.set("extend.mode", (Object)CodeModeType.CODE.getValue());
        tgtworkflowNode.setScript(diProcessor.toJSON());
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void processSqoopTarget(SqoopParameters parameter, DIJsonProcessor writerJp) {
        writerJp.set("stepType", (Object)StringUtils.lowerCase((String)parameter.getTargetType()));
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getTargetType(), (CharSequence)"mysql")) {
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)parameter.getTargetParams(), TargetMysqlParameter.class);
            Optional.ofNullable(targetMysqlParameter).ifPresent(p -> {
                String[] stringArray;
                ListUtils.emptyIfNull((List)this.taskContext.getWorkflowDatasources()).stream().filter(ds -> Objects.equals(ds.getDatasourceId(), targetMysqlParameter.getTargetDatasource())).findFirst().ifPresent(ds -> writerJp.set("parameter.datasource", (Object)ds.getName()));
                writerJp.set("parameter.table", (Object)targetMysqlParameter.getTargetTable());
                writerJp.set("parameter.preSql", (Object)Optional.ofNullable(StringUtils.split((String)targetMysqlParameter.getPreQuery(), (String)",")).orElse(new String[0]));
                if (StringUtils.isBlank((CharSequence)targetMysqlParameter.getTargetColumns())) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                } else {
                    stringArray = StringUtils.split((String)targetMysqlParameter.getTargetColumns(), (String)",");
                }
                writerJp.set("parameter.column", (Object)stringArray);
                if (StringUtils.equalsIgnoreCase((CharSequence)targetMysqlParameter.getTargetUpdateMode(), (CharSequence)"updateonly")) {
                    writerJp.set("parameter.writeMode", (Object)"update");
                } else {
                    writerJp.set("parameter.writeMode", (Object)"replace");
                }
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getTargetType(), (CharSequence)"hive")) {
            TargetHiveParameter targetHiveParameter = (TargetHiveParameter)JSONUtils.parseObject((String)parameter.getTargetParams(), TargetHiveParameter.class);
            Optional.ofNullable(targetHiveParameter).ifPresent(p -> {
                ListUtils.emptyIfNull((List)this.taskContext.getWorkflowDatasources()).stream().filter(ds -> StringUtils.equals((CharSequence)String.valueOf(ds.getDatasourceId()), (CharSequence)targetHiveParameter.getHiveDatabase())).findFirst().ifPresent(ds -> writerJp.set("parameter.datasource", (Object)ds.getName()));
                writerJp.set("parameter.table", (Object)targetHiveParameter.getHiveTable());
                String[] keys = Optional.ofNullable(StringUtils.split((String)targetHiveParameter.getHivePartitionKey(), (String)",")).orElse(new String[0]);
                String[] values = Optional.ofNullable(StringUtils.split((String)targetHiveParameter.getHivePartitionValue(), (String)",")).orElse(new String[0]);
                ArrayList<String> partitions = new ArrayList<String>();
                for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
                    partitions.add(Joiner.on((String)"=").join((Object)keys[i], (Object)values[i], new Object[0]));
                }
                writerJp.set("parameter.partition", (Object)Joiner.on((String)",").join(partitions));
                writerJp.set("parameter.hdfsUsername", (Object)"hdfs");
                writerJp.set("parameter.writeMode", (Object)"append");
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getTargetType(), (CharSequence)"hdfs")) {
            TargetHdfsParameter targetHdfsParameter = (TargetHdfsParameter)JSONUtils.parseObject((String)parameter.getSourceParams(), TargetHdfsParameter.class);
            Optional.ofNullable(targetHdfsParameter).ifPresent(p -> {
                writerJp.set("parameter.path", (Object)p.getTargetPath());
                writerJp.set("parameter.compress", (Object)targetHdfsParameter.getCompressionCodec());
                writerJp.set("parameter.datasource", (Object)"hdfs");
                writerJp.set("parameter.fileType", (Object)targetHdfsParameter.getFileType());
                if (StringUtils.equalsIgnoreCase((CharSequence)"parquet", (CharSequence)targetHdfsParameter.getFileType())) {
                    writerJp.set("parameter.writeMode", (Object)"noConflict");
                } else {
                    writerJp.set("parameter.writeMode", (Object)"append");
                }
            });
        }
    }

    private void processSqoopSource(SqoopParameters parameter, DIJsonProcessor readerJp) {
        readerJp.set("stepType", (Object)StringUtils.lowerCase((String)parameter.getSourceType()));
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getSourceType(), (CharSequence)"mysql")) {
            SourceMysqlParameter mysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)parameter.getSourceParams(), SourceMysqlParameter.class);
            Optional.ofNullable(mysqlParameter).ifPresent(p -> {
                String[] stringArray;
                ListUtils.emptyIfNull((List)this.taskContext.getWorkflowDatasources()).stream().filter(ds -> Objects.equals(ds.getDatasourceId(), mysqlParameter.getSrcDatasource())).findFirst().ifPresent(ds -> readerJp.set("parameter.datasource", (Object)ds.getName()));
                readerJp.set("parameter.table", (Object)mysqlParameter.getSrcTable());
                readerJp.set("parameter.where", (Object)StringUtils.substringAfter((String)StringUtils.lowerCase((String)mysqlParameter.getSrcQuerySql()), (String)"where"));
                if (StringUtils.isBlank((CharSequence)mysqlParameter.getSrcColumns())) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                } else {
                    stringArray = StringUtils.split((String)mysqlParameter.getSrcColumns(), (String)",");
                }
                readerJp.set("parameter.column", (Object)stringArray);
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getSourceType(), (CharSequence)"hive")) {
            SourceHiveParameter sourceHiveParameter = (SourceHiveParameter)JSONUtils.parseObject((String)parameter.getSourceParams(), SourceHiveParameter.class);
            Optional.ofNullable(sourceHiveParameter).ifPresent(p -> {
                ListUtils.emptyIfNull((List)this.taskContext.getWorkflowDatasources()).stream().filter(ds -> StringUtils.equals((CharSequence)String.valueOf(ds.getDatasourceId()), (CharSequence)sourceHiveParameter.getHiveDatabase())).findFirst().ifPresent(ds -> readerJp.set("parameter.datasource", (Object)ds.getName()));
                readerJp.set("parameter.table", (Object)sourceHiveParameter.getHiveTable());
                String[] keys = Optional.ofNullable(StringUtils.split((String)sourceHiveParameter.getHivePartitionKey(), (String)",")).orElse(new String[0]);
                String[] values = Optional.ofNullable(StringUtils.split((String)sourceHiveParameter.getHivePartitionValue(), (String)",")).orElse(new String[0]);
                ArrayList<String> partitions = new ArrayList<String>();
                for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
                    partitions.add(Joiner.on((String)"=").join((Object)keys[i], (Object)values[i], new Object[0]));
                }
                readerJp.set("parameter.partition", (Object)Joiner.on((String)",").join(partitions));
                readerJp.set("parameter.readMode", (Object)"hdfs");
                readerJp.set("parameter.hdfsUsername", (Object)"hdfs");
                List columns = Arrays.stream(keys).map(key -> {
                    HashMap<String, String> column = new HashMap<String, String>();
                    column.put("type", "string");
                    column.put("value", (String)key);
                    return column;
                }).collect(Collectors.toList());
                readerJp.set("parameter.hivePartitionColumn", columns);
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parameter.getSourceType(), (CharSequence)"hdfs")) {
            SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)parameter.getSourceParams(), SourceHdfsParameter.class);
            Optional.ofNullable(sourceHdfsParameter).ifPresent(p -> readerJp.set("parameter.path", (Object)p.getExportDir()));
        }
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.DI.name();
    }
}

