/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.conditions.ConditionResult;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentTaskModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.dependent.DependentParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionsNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(ConditionsNodeConvert.class);

    public ConditionsNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.VIRTUAL.name();
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        JsonObject param = (JsonObject)GsonUtils.fromJsonString((String)workflowNode.getScript(), JsonObject.class);
        DependentParameters dependentParameters = null;
        if (param.get("dependence") != null) {
            dependentParameters = (DependentParameters)GsonUtils.fromJson((JsonObject)param.getAsJsonObject("dependence"), DependentParameters.class);
        }
        if (dependentParameters == null || dependentParameters.getDependTaskList() == null || dependentParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)workflowNode.getScript());
            return Collections.emptyList();
        }
        AtomicInteger outerRelationIndex = new AtomicInteger(0);
        List dependencies = dependentParameters.getDependTaskList();
        List taskDepJoinNodes = ListUtils.emptyIfNull((List)dependencies).stream().map(dependentTaskModel -> this.conditionNodeToJoinNode(workflowNode, (DependentTaskModel)dependentTaskModel, outerRelationIndex.getAndIncrement())).collect(Collectors.toList());
        List parentNodes = this.getParentNodes(workflowNode);
        List nodeRelations = this.workflow.getNodeRelations();
        ListUtils.emptyIfNull(taskDepJoinNodes).forEach(x -> {
            ListUtils.emptyIfNull((List)parentNodes).forEach(y -> nodeRelations.add(new RelationPackage(y.getNodeId(), x.getNodeId(), RelationPackage.ReType.NODE)));
            tgtNodes.add((WorkflowNode)x);
        });
        DependentParameters dependency = dependentParameters;
        WorkflowNode joinSuccessNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        joinSuccessNode.setNodeType(CodeProgramType.CONTROLLER_JOIN.name());
        joinSuccessNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"join", "success"}));
        joinSuccessNode.setNodeId(joinSuccessNode.getNodeName());
        ControllerJoinCode joinSuccessCode = new ControllerJoinCode();
        joinSuccessCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(x -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependency.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(0));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(1));
                }
            }
            branch.setNode(this.getDefaultNodeOutput(x.getNodeId()));
            branch.setRunStatus(Collections.singletonList("1"));
            return branch;
        }).collect(Collectors.toList()));
        joinSuccessCode.setResultStatus("1");
        joinSuccessNode.setScript(joinSuccessCode.getContent());
        List childrenNodeIds = this.getChildrenNodeIds(workflowNode);
        if (CollectionUtils.isEmpty((Collection)this.workflow.getNodeRelations())) {
            this.workflow.setNodeRelations(new ArrayList());
        }
        ListUtils.emptyIfNull(taskDepJoinNodes).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x.getNodeId(), joinSuccessNode.getNodeId(), RelationPackage.ReType.NODE)));
        if (null != param.get("conditionResult")) {
            this.addDownStreamSuccess(param.get("conditionResult").toString(), joinSuccessNode, childrenNodeIds);
        }
        WorkflowNode joinFailureNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        joinFailureNode.setNodeType(CodeProgramType.CONTROLLER_JOIN.name());
        joinFailureNode.setNodeName(Joiner.on((String)"_").join((Object)joinFailureNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"join", "failure"}));
        joinFailureNode.setNodeId(joinFailureNode.getNodeName());
        ControllerJoinCode joinFailureCode = new ControllerJoinCode();
        joinFailureCode.setBranchList(ListUtils.emptyIfNull(taskDepJoinNodes).stream().map(x -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependency.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(1));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(0));
                }
            }
            branch.setNode(this.getDefaultNodeOutput(x.getNodeId()));
            branch.setRunStatus(Collections.singletonList("0"));
            return branch;
        }).collect(Collectors.toList()));
        joinFailureCode.setResultStatus("1");
        joinFailureNode.setScript(joinFailureCode.getContent());
        ListUtils.emptyIfNull(taskDepJoinNodes).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x.getNodeId(), joinFailureNode.getNodeId(), RelationPackage.ReType.NODE)));
        if (null != param.get("conditionResult")) {
            this.addDownStreamFailed(param.get("conditionResult").toString(), joinFailureNode, childrenNodeIds);
        }
        tgtNodes.add(joinSuccessNode);
        tgtNodes.add(joinFailureNode);
        ListUtils.emptyIfNull(tgtNodes).forEach(arg_0 -> ((ConditionsNodeConvert)this).supplyBaseMsg(arg_0));
        return tgtNodes;
    }

    private void addDownStreamSuccess(String conditoinStr, WorkflowNode successJoinWorkflowNode, List<String> childrenNodeIds) {
        ConditionResult conditionResult = (ConditionResult)GsonUtils.fromJsonString((String)conditoinStr, ConditionResult.class);
        Optional.ofNullable(conditionResult.getSuccessNode()).filter(successNode -> ListUtils.emptyIfNull((List)successNode).stream().anyMatch(n -> childrenNodeIds.contains(String.valueOf(n)))).ifPresent(successNode -> {
            String joinWorkflowNodeNodeId = successJoinWorkflowNode.getNodeId();
            successNode.forEach(n -> this.workflow.getNodeRelations().add(new RelationPackage(joinWorkflowNodeNodeId, String.valueOf(n), RelationPackage.ReType.NODE)));
        });
    }

    private void addDownStreamFailed(String conditoinStr, WorkflowNode failedJoinWorkflowNode, List<String> childrenNodeIds) {
        ConditionResult conditionResult = (ConditionResult)GsonUtils.fromJsonString((String)conditoinStr, ConditionResult.class);
        Optional.ofNullable(conditionResult.getFailedNode()).filter(failedNode -> ListUtils.emptyIfNull((List)failedNode).stream().anyMatch(n -> childrenNodeIds.contains(String.valueOf(n)))).ifPresent(successNode -> {
            String joinWorkflowNodeNodeId = failedJoinWorkflowNode.getNodeId();
            successNode.forEach(n -> this.workflow.getNodeRelations().add(new RelationPackage(joinWorkflowNodeNodeId, String.valueOf(n), RelationPackage.ReType.NODE)));
        });
    }

    private WorkflowNode conditionNodeToJoinNode(WorkflowNode workflowNode, DependentTaskModel dependentTaskModel, int outerRelationIndex) {
        WorkflowNode joinNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        joinNode.setNodeId(workflowNode.getNodeId() + "_" + outerRelationIndex);
        joinNode.setNodeType(CodeProgramType.CONTROLLER_JOIN.name());
        joinNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"join", outerRelationIndex}));
        List branchList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().filter(dependentItem -> dependentItem.getStatus() != null).map(dependentItem -> {
            ControllerJoinCode.Branch branch = new ControllerJoinCode.Branch();
            switch (dependentTaskModel.getRelation()) {
                case OR: {
                    branch.setLogic(Integer.valueOf(0));
                    break;
                }
                case AND: {
                    branch.setLogic(Integer.valueOf(1));
                }
            }
            List workflowNodes = this.workflow.getWorkflowNodes();
            WorkflowNode upstreamNode = ListUtils.emptyIfNull((List)workflowNodes).stream().filter(node -> node.getNodeId().equals(String.valueOf(dependentItem.getDepTaskCode()))).findFirst().orElse(null);
            if (upstreamNode == null) {
                log.error("can not get task definition by code {}", (Object)dependentItem.getDepTaskCode());
                return null;
            }
            branch.setNode(this.getDefaultNodeOutput(upstreamNode.getNodeId()));
            switch (dependentItem.getStatus()) {
                case FAILURE: {
                    branch.setRunStatus(Collections.singletonList("0"));
                    break;
                }
                case SUCCESS: {
                    branch.setRunStatus(Collections.singletonList("1"));
                }
            }
            return branch;
        }).collect(Collectors.toList());
        ControllerJoinCode joinCode = new ControllerJoinCode();
        joinCode.setBranchList(branchList);
        joinCode.setResultStatus("1");
        joinNode.setScript(joinCode.getContent());
        return joinNode;
    }
}

