/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.emr.tools;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.emr.tools.EmrWebClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EmrWebGetter {
    private EmrWebClient client;
    private String resourceSavePath;

    public EmrWebGetter(String workspaceId, String endPoint, String cookie, String resourceSavePath) {
        this.resourceSavePath = resourceSavePath;
        this.client = new EmrWebClient(workspaceId, endPoint, cookie, resourceSavePath);
    }

    public List<WorkflowDatasource> getDatasourceList() {
        ArrayList<WorkflowDatasource> res = new ArrayList<WorkflowDatasource>();
        JSONArray datasourceList = this.client.listDataSource();
        for (int i = 0; i < datasourceList.size(); ++i) {
            WorkflowDatasource ds = new WorkflowDatasource();
            JSONObject datasource = datasourceList.getJSONObject(i);
            ds.setDatasourceId(datasource.getString("id"));
            ds.setName(datasource.getString("name"));
            ds.setCustomProperties(new HashMap());
            ds.getCustomProperties().put("RAW_INFO", datasource.toJSONString(new JSONWriter.Feature[0]));
            res.add(ds);
        }
        return res;
    }

    public List<WorkflowFileResource> getResourceList() {
        JSONArray resourceList = this.client.listResource();
        this.client.downloadAllResource(resourceList);
        ArrayList<WorkflowFileResource> files = new ArrayList<WorkflowFileResource>();
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject resource = resourceList.getJSONObject(i);
            if (resource.getBoolean("directory").booleanValue()) continue;
            WorkflowFileResource file = new WorkflowFileResource();
            file.setFileId(resource.getString("id"));
            file.setName(resource.getString("fileName"));
            file.setPath(this.resourceSavePath + resource.getString("fullName"));
            file.setFolder(resource.getString("fullName").substring(0, resource.getString("fullName").length() - resource.getString("fileName").length() - 1));
            file.setFileType(resource.getString("type"));
            files.add(file);
        }
        return files;
    }
}

