/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.emr.handle;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV3PackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.dsv3.converter.Dolphinv32WorkflowConverter;
import com.aliyun.migration.workflow.migration.emr.tools.EmrWebGetter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrFileHandler {
    private static final Logger log = LoggerFactory.getLogger(EmrFileHandler.class);
    protected Datasource scheduleDataSource;
    protected TaskContext taskContext;
    protected DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage;
    private Dolphinv32WorkflowConverter converter = new Dolphinv32WorkflowConverter();
    private Map<String, Object> projectParam;

    public EmrFileHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        this.scheduleDataSource = scheduleDataSource;
        this.taskContext = taskContext;
    }

    public void init() {
        Map properties = this.scheduleDataSource.getProperties();
        String projectDefinitionFilePath = properties.getOrDefault("source-file-path", "project.json");
        File projectDefinitionFile = new File(projectDefinitionFilePath);
        if (!projectDefinitionFile.exists()) {
            this.dolphinSchedulerPackage = new DolphinSchedulerPackage();
            log.error("EmrFileHandler init error,file not exist,filePath:{}", (Object)projectDefinitionFilePath);
        }
        File dolphinPackageFilePath = null;
        try {
            File rootDir;
            File pkgDir;
            String projectDefinitionRawScript = FileUtils.readFileToString((File)projectDefinitionFile);
            JSONObject projectDefinition = JSONObject.parseObject((String)projectDefinitionRawScript);
            String projectName = projectDefinition.getJSONObject("project").getString("name");
            String processDefinition = projectDefinition.getJSONArray("dagDataSchedules").toJSONString(new JSONWriter.Feature[0]);
            String projects = JSONArray.of((Object)projectDefinition.getJSONObject("project")).toJSONString(new JSONWriter.Feature[0]);
            this.projectParam = new HashMap<String, Object>();
            if (projectDefinition.containsKey("projectParameterList") && !projectDefinition.getJSONArray("projectParameterList").isEmpty()) {
                projectDefinition.getJSONArray("projectParameterList").stream().forEach(item -> {
                    JSONObject jsonObject = (JSONObject)item;
                    this.projectParam.put(jsonObject.getString("paramName"), jsonObject.get("paramValue"));
                });
            }
            if ((pkgDir = new File(rootDir = projectDefinitionFile.getParentFile(), projectName)).exists()) {
                FileUtils.deleteDirectory((File)pkgDir);
            }
            FileUtils.forceMkdir((File)pkgDir);
            FileUtils.forceMkdir((File)new File(pkgDir, "datasource"));
            FileUtils.forceMkdir((File)new File(pkgDir, "projects"));
            FileUtils.forceMkdir((File)new File(pkgDir, "projects/" + projectName));
            FileUtils.forceMkdir((File)new File(pkgDir, "projects/" + projectName + "/processDefinition"));
            FileUtils.forceMkdir((File)new File(pkgDir, "resource"));
            FileUtils.forceMkdir((File)new File(pkgDir, "udfFunction"));
            FileUtils.writeStringToFile((File)new File(pkgDir, "projects/" + projectName + "/processDefinition/process_definitions_page_1.json"), (String)processDefinition);
            FileUtils.writeStringToFile((File)new File(pkgDir, "projects.json"), (String)projects);
            FileUtils.writeStringToFile((File)new File(pkgDir, "datasource/datasource_page_1.json"), (String)"[]");
            FileUtils.writeStringToFile((File)new File(pkgDir, "resource/resources.json"), (String)"[]");
            FileUtils.writeStringToFile((File)new File(pkgDir, "package_info.json"), (String)"{\"version\":\"3.2.0\"}");
            FileUtils.writeStringToFile((File)new File(pkgDir, "udfFunction/udf_function_page_1.json"), (String)"[]");
            dolphinPackageFilePath = new File(rootDir, projectName);
        }
        catch (Exception e) {
            this.dolphinSchedulerPackage = new DolphinSchedulerPackage();
            log.error("EmrFileHandler init error", (Throwable)e);
        }
        if (dolphinPackageFilePath != null) {
            DolphinSchedulerV3PackageLoader loader = new DolphinSchedulerV3PackageLoader(dolphinPackageFilePath);
            try {
                loader.loadPackage();
                this.dolphinSchedulerPackage = loader.getDolphinSchedulerPackage();
                FileUtils.forceDelete(dolphinPackageFilePath);
            }
            catch (Exception e) {
                this.dolphinSchedulerPackage = new DolphinSchedulerPackage();
                log.error("EmrFileHandler init error", (Throwable)e);
            }
        }
        log.info("EmrFileHandler init");
    }

    public WorkflowProjectPackage read() {
        log.info("EmrFileHandler read");
        WorkflowProjectPackage projectPackage = this.converter.convert(this.dolphinSchedulerPackage);
        if (this.projectParam != null && !this.projectParam.isEmpty() && projectPackage.getWorkflowList() != null && !projectPackage.getWorkflowList().isEmpty()) {
            projectPackage.getWorkflowList().forEach(x -> {
                if (x.getCustomProperties() == null) {
                    x.setCustomProperties(new HashMap());
                }
                this.projectParam.forEach(x.getCustomProperties()::put);
            });
        }
        if (this.taskContext.getReaderDatasource().getProperties() != null && this.taskContext.getReaderDatasource().getProperties().containsKey("cookie") && this.taskContext.getReaderDatasource().getProperties().containsKey("region") && this.taskContext.getReaderDatasource().getProperties().containsKey("projectId")) {
            Map properties = this.scheduleDataSource.getProperties();
            String projectDefinitionFilePath = properties.getOrDefault("source-file-path", "project.json");
            File projectDefinitionFile = new File(projectDefinitionFilePath);
            File resourceTempDir = new File(projectDefinitionFile.getParentFile(), "resource");
            try {
                EmrWebGetter emrWebGetter = new EmrWebGetter((String)this.taskContext.getReaderDatasource().getProperties().get("projectId"), (String)this.taskContext.getReaderDatasource().getProperties().get("region"), (String)this.taskContext.getReaderDatasource().getProperties().get("cookie"), resourceTempDir.getAbsolutePath());
                projectPackage.setDatasources(emrWebGetter.getDatasourceList());
                if (resourceTempDir.exists()) {
                    FileUtils.forceDelete((File)resourceTempDir);
                }
                FileUtils.forceMkdir((File)resourceTempDir);
                projectPackage.setFiles(emrWebGetter.getResourceList());
                projectPackage.getWorkflowList().forEach(x -> {
                    x.setFiles(new ArrayList());
                    for (WorkflowFileResource file : projectPackage.getFiles()) {
                        x.getFiles().add((WorkflowFileResource)BwmJsonUtil.deepCopy((Object)file, WorkflowFileResource.class));
                    }
                });
            }
            catch (Exception e) {
                log.error("EmrFileHandler get resource error", (Throwable)e);
            }
        }
        return projectPackage;
    }
}

