/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.domain.constant;

public enum SQLTaskResultEnum {
    SQL_TASK_STATUS_RUNNING("\u4efb\u52a1\u8fd0\u884c\u4e2d", 0, "RUNNING"),
    SQL_TASK_STATUS_ALL_SUCCESS("\u5168\u90e8\u8f6c\u6362\u6210\u529f", 1, "ALL_SUCCESS"),
    SQL_TASK_STATUS_PARTIAL_SUCCESS("\u90e8\u5206\u8f6c\u6362\u6210\u529f", 2, "PARTIAL_SUCCESS"),
    SQL_TASK_STATUS_FAILURE("\u8f6c\u6362\u5931\u8d25", 3, "FAILURE"),
    SQL_TASK_STATUS_NOT_CONFIG("\u672a\u914d\u7f6eSQL\u4efb\u52a1", 4, "NOT_CONFIG"),
    SQL_TASK_STATUS_OVER("\u4efb\u52a1\u8fd0\u884c\u5b8c\u6210", 5, "OVER"),
    SQL_TASK_STATUS_CREATE_EXCEPTION("\u4efb\u52a1\u521b\u5efa\u5f02\u5e38", 6, "CREATE_EXCEPTION");

    private final String name;
    private final int statusCode;
    private final String statusName;

    private SQLTaskResultEnum(String name, int statusCode, String statusName) {
        this.name = name;
        this.statusCode = statusCode;
        this.statusName = statusName;
    }

    public String getName() {
        return this.name;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public static SQLTaskResultEnum valueOf(int statusCode) {
        for (SQLTaskResultEnum value : SQLTaskResultEnum.values()) {
            if (value.getStatusCode() != statusCode) continue;
            return value;
        }
        return SQL_TASK_STATUS_NOT_CONFIG;
    }

    public static SQLTaskResultEnum nameOf(String statusName) {
        for (SQLTaskResultEnum value : SQLTaskResultEnum.values()) {
            if (!value.getStatusName().equalsIgnoreCase(statusName)) continue;
            return value;
        }
        return SQL_TASK_STATUS_NOT_CONFIG;
    }
}

