/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils;

import com.aliyun.rapt.commons.utils.StringUtils;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class OsUtils {
    public static final String USER_HOME = OsUtils.locateUserHome();
    private static final String OS = OsUtils.innerGetOS();
    public static final boolean IS_OS_UNIX = OsUtils.innerIsUnix();
    public static final boolean IS_OS_MAC_OSX = OsUtils.innerIsMacOS();
    public static final boolean IS_OS_WINDOWS = OsUtils.innerIsWindows();

    private OsUtils() {
    }

    private static boolean innerIsUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean innerIsWindows() {
        return OS.startsWith("Windows");
    }

    private static boolean innerIsMacOS() {
        return OS.startsWith("Mac");
    }

    private static String innerGetOS() {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        }).toString();
    }

    private static String locateUserHome() {
        String userHome = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.home");
            }
        }).toString();
        if (StringUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    public static boolean isUnix() {
        return IS_OS_UNIX;
    }

    public static String getUserHome() {
        return USER_HOME;
    }

    public static void main(String[] args) {
        System.out.println(USER_HOME);
    }
}

