/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils.stack;

import com.aliyun.rapt.commons.utils.Assert;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProvider;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StackTraceElementProviderJdk
implements StackTraceElementProvider {
    private StackWalker walker;
    private int depth;

    public StackTraceElementProviderJdk() {
        this.fillInStackTrace();
    }

    public StackTraceElementProviderJdk(boolean lazy) {
        if (!lazy) {
            this.fillInStackTrace();
        }
    }

    @Override
    public StackTraceElement[] getStackTraceElements(int from, int to) {
        int theDepth;
        if (this.walker == null) {
            this.fillInStackTrace();
        }
        Assert.isTrue((theDepth = Math.min(to, this.depth)) > from, "from should not large than stack depth");
        int range = theDepth - from;
        StackWalker walker = StackWalker.getInstance();
        return walker.walk(stackFrameStream -> (StackTraceElement[])stackFrameStream.skip(from).map(StackWalker.StackFrame::toStackTraceElement).limit(range).toArray(StackTraceElement[]::new));
    }

    @Override
    public StackTraceElement getStackTraceElement(int depth) {
        if (this.walker == null) {
            this.fillInStackTrace();
        }
        Assert.isTrue(depth >= 0, "the depth should not less than 0");
        Assert.isTrue(depth < this.depth, "the depth should not large than stack depth");
        Optional<StackTraceElement> optional = this.walker.walk(x -> x.skip(depth).findFirst()).map(StackWalker.StackFrame::toStackTraceElement);
        return optional.orElseGet(() -> new StackTraceElement("unknown", "unknown", "unknown", -1));
    }

    @Override
    public int getStackTraceDepth() {
        if (this.walker == null) {
            this.fillInStackTrace();
        }
        return this.depth;
    }

    @Override
    public void fillInStackTrace() {
        this.walker = StackWalker.getInstance();
        this.depth = this.walker.walk(x -> (int)x.count()) - 3;
        if (this.depth < 0) {
            this.depth = 0;
        }
    }
}

