/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.dolphinscheduler.spi.params.base.DataType;
import org.apache.dolphinscheduler.spi.params.base.TriggerType;

@JsonDeserialize(builder=Builder.class)
public class Validate {
    @JsonProperty(value="required")
    private boolean required;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="trigger")
    private String trigger;
    @JsonProperty(value="min")
    private Double min;
    @JsonProperty(value="max")
    private Double max;

    private Validate() {
    }

    private Validate(Builder builder) {
        this.required = builder.required;
        this.message = builder.message;
        this.type = builder.type;
        this.trigger = builder.trigger;
        this.min = builder.min;
        this.max = builder.max;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="set")
    public static class Builder {
        private boolean required = false;
        private String message;
        private String type = DataType.STRING.getDataType();
        private String trigger = TriggerType.BLUR.getTriggerType();
        private Double min;
        private Double max;

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder setMin(Double min) {
            this.min = min;
            return this;
        }

        public Builder setMax(Double max) {
            this.max = max;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Validate build() {
            return new Validate(this);
        }
    }
}

