/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.ThreadLocalUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class IntlUtils {
    public static Map<String, Map<String, String>> intlResource = new HashMap<String, Map<String, String>>();
    public static final String CLASS_PATH_RESOURCE = "i18n";

    public static IntlBo get(String key) {
        IntlBo intlBo = new IntlBo();
        Map<String, String> resource = IntlUtils.getLanguageResource();
        if (null != resource && resource.containsKey(key)) {
            intlBo.setValue(resource.get(key));
        }
        return intlBo;
    }

    public static IntlBo get(String key, Map<String, String> params) {
        IntlBo intlBo = new IntlBo();
        Map<String, String> resource = IntlUtils.getLanguageResource();
        if (null != resource && resource.containsKey(key)) {
            AtomicReference<String> value = new AtomicReference<String>(resource.get(key));
            MapUtils.emptyIfNull(params).forEach((name, val) -> value.set(((String)value.get()).replaceAll("\\{" + name + "\\}", (String)val)));
            intlBo.setValue(value.get());
        }
        return intlBo;
    }

    public static Map<String, String> getLanguageResource() {
        String lang = ThreadLocalUtils.getLocale().toString();
        if (null != intlResource && intlResource.containsKey(lang)) {
            return intlResource.get(lang);
        }
        try {
            String content = IntlUtils.readFileToStr(lang + ".json");
            Map result = (Map)GsonUtils.fromJsonString(content, new TypeToken<Map<String, String>>(){}.getType());
            intlResource.put(lang, result);
            return result;
        }
        catch (Exception var8) {
            return null;
        }
    }

    public static String readFileToStr(String file) throws IOException {
        String path = "i18n/" + file;
        try (InputStream inputStream = IntlUtils.class.getClassLoader().getResourceAsStream(path);){
            if (inputStream != null) {
                String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static String getByEnum(Enum<?> tEnum) {
        if (tEnum == null) {
            return null;
        }
        return IntlUtils.get(IntlUtils.getEnumKey(tEnum)).d(tEnum.name());
    }

    public static String getByEnum(Enum<?> tEnum, Object ... params) {
        if (tEnum == null) {
            return null;
        }
        if (params != null) {
            AtomicInteger index = new AtomicInteger(0);
            Map<String, String> paramMap = Arrays.stream(params).collect(Collectors.toMap(v -> String.valueOf(index.getAndIncrement()), String::valueOf));
            return IntlUtils.get(IntlUtils.getEnumKey(tEnum), paramMap).d(tEnum.name());
        }
        return IntlUtils.getByEnum(tEnum);
    }

    private static String getEnumKey(Enum<?> tEnum) {
        return Joiner.on((String)".").join((Object)tEnum.getClass().getSimpleName(), (Object)tEnum.name(), new Object[0]);
    }

    public static class IntlBo {
        private String value;

        public String d(String content) {
            return null == this.value ? content : this.value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntlBo)) {
                return false;
            }
            IntlBo other = (IntlBo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null) {
                return other$value == null;
            }
            return this$value.equals(other$value);
        }

        protected boolean canEqual(Object other) {
            return other instanceof IntlBo;
        }

        public int hashCode() {
            int result = 1;
            String value = this.getValue();
            result = result * 59 + (value == null ? 43 : value.hashCode());
            return result;
        }

        public String toString() {
            return "IntlUtils.IntlBo(value=" + this.getValue() + ")";
        }
    }

    public static class IntlPair {
        private IntlLang lang;
        private String text;

        public static IntlPair of(IntlLang lang, String text) {
            return new IntlPair().setLang(lang).setText(text);
        }

        public IntlLang getLang() {
            return this.lang;
        }

        public String getText() {
            return this.text;
        }

        public IntlPair setLang(IntlLang lang) {
            this.lang = lang;
            return this;
        }

        public IntlPair setText(String text) {
            this.text = text;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntlPair)) {
                return false;
            }
            IntlPair other = (IntlPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IntlLang this$lang = this.getLang();
            IntlLang other$lang = other.getLang();
            if (this$lang == null ? other$lang != null : !((Object)((Object)this$lang)).equals((Object)other$lang)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IntlPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IntlLang $lang = this.getLang();
            result = result * 59 + ($lang == null ? 43 : ((Object)((Object)$lang)).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "IntlUtils.IntlPair(lang=" + (Object)((Object)this.getLang()) + ", text=" + this.getText() + ")";
        }
    }

    public static class International {
        private final Map<IntlLang, String> intl = new HashMap<IntlLang, String>();

        public String getIntl(IntlLang lang, String defaultText) {
            return MapUtils.emptyIfNull(this.intl).getOrDefault((Object)lang, defaultText);
        }

        public void putIntl(IntlPair ... intlPairs) {
            Optional.ofNullable(intlPairs).ifPresent(entries -> Arrays.asList(intlPairs).forEach(ent -> this.intl.put(ent.getLang(), ent.getText())));
        }

        public Map<IntlLang, String> getIntl() {
            return this.intl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof International)) {
                return false;
            }
            International other = (International)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<IntlLang, String> this$intl = this.getIntl();
            Map<IntlLang, String> other$intl = other.getIntl();
            return !(this$intl == null ? other$intl != null : !((Object)this$intl).equals(other$intl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof International;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<IntlLang, String> $intl = this.getIntl();
            result = result * 59 + ($intl == null ? 43 : ((Object)$intl).hashCode());
            return result;
        }

        public String toString() {
            return "IntlUtils.International(intl=" + this.getIntl() + ")";
        }
    }

    public static enum IntlLang {
        zh_CN,
        en_US,
        zh_TW;


        public static IntlLang of(Locale locale) {
            if (locale == null) {
                return null;
            }
            for (IntlLang lang : IntlLang.values()) {
                if (!StringUtils.equals((CharSequence)lang.name(), (CharSequence)locale.toString())) continue;
                return lang;
            }
            return null;
        }
    }
}

