/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteUtils.class);

    public static <T> T executeWithRetry(ExecuteCommand<T> command, int retryTimes, long retryInterval) throws Exception {
        T ret = null;
        int retryCount = 0;
        boolean ended = false;
        Exception caughtException = null;
        while (true) {
            try {
                command.setRetryCount(retryCount);
                ret = command.run();
                ended = true;
            }
            catch (Exception e) {
                LOGGER.warn("Got exception: {}", (Object)e.getMessage());
                caughtException = e;
                if (!command.isRetry(e) || ++retryCount > retryTimes) break;
                LOGGER.warn("retrying...");
                Thread.sleep(retryInterval);
                continue;
            }
            break;
        }
        if (!ended) {
            LOGGER.warn("execute end, throw exception");
            throw caughtException;
        }
        LOGGER.info("execute end, success return");
        LOGGER.debug("return value: {}", ret);
        return ret;
    }

    public static <R> boolean waitForState(WaitForStateCommand<R> command) throws InterruptedException {
        String timeoutMsg;
        int counter = command.getTimeoutSeconds();
        do {
            block7: {
                try {
                    R procedureResult = command.getProcedure().call();
                    command.setProcedureResult(procedureResult);
                }
                catch (Throwable throwable) {
                    LOGGER.error("", throwable);
                    command.setException(throwable);
                    command.setSuccess(false);
                }
                try {
                    Boolean done = command.getCheckDoneFunc().apply(command);
                    if (done.booleanValue()) {
                        LOGGER.info("procedure done");
                        command.setSuccess(true);
                    }
                    break block7;
                }
                catch (Throwable e) {
                    LOGGER.error("", e);
                    command.setException(e);
                    command.setSuccess(false);
                }
                break;
            }
            LOGGER.info("sleeping for {} seconds", (Object)command.getIntervalSeconds());
            Thread.sleep(1000L * (long)command.getIntervalSeconds());
        } while (--counter > 0);
        String string = timeoutMsg = counter <= 0 ? "wait for procedure timeout after " + command.getTimeoutSeconds() + " seconds" : "";
        if (command.isSuccess() && counter > 0) {
            return true;
        }
        command.setException(new RuntimeException(timeoutMsg));
        throw new RuntimeException(command.getException());
    }

    public static abstract class ExecuteCommand<T> {
        protected int retryCount;

        public int getRetryCount() {
            return this.retryCount;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public abstract T run() throws Exception;

        public abstract boolean isRetry(Exception var1);
    }

    public static class WaitForStateCommand<R> {
        private Callable<R> procedure;
        private R procedureResult;
        private Function<WaitForStateCommand<R>, Boolean> checkDoneFunc;
        private int intervalSeconds = 1;
        private int timeoutSeconds = 60;
        private boolean success = false;
        private Throwable exception;

        public Callable<R> getProcedure() {
            return this.procedure;
        }

        public R getProcedureResult() {
            return this.procedureResult;
        }

        public Function<WaitForStateCommand<R>, Boolean> getCheckDoneFunc() {
            return this.checkDoneFunc;
        }

        public int getIntervalSeconds() {
            return this.intervalSeconds;
        }

        public int getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Throwable getException() {
            return this.exception;
        }

        public WaitForStateCommand<R> setProcedure(Callable<R> procedure) {
            this.procedure = procedure;
            return this;
        }

        public WaitForStateCommand<R> setProcedureResult(R procedureResult) {
            this.procedureResult = procedureResult;
            return this;
        }

        public WaitForStateCommand<R> setCheckDoneFunc(Function<WaitForStateCommand<R>, Boolean> checkDoneFunc) {
            this.checkDoneFunc = checkDoneFunc;
            return this;
        }

        public WaitForStateCommand<R> setIntervalSeconds(int intervalSeconds) {
            this.intervalSeconds = intervalSeconds;
            return this;
        }

        public WaitForStateCommand<R> setTimeoutSeconds(int timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public WaitForStateCommand<R> setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public WaitForStateCommand<R> setException(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WaitForStateCommand)) {
                return false;
            }
            WaitForStateCommand other = (WaitForStateCommand)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIntervalSeconds() != other.getIntervalSeconds()) {
                return false;
            }
            if (this.getTimeoutSeconds() != other.getTimeoutSeconds()) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            Callable<R> this$procedure = this.getProcedure();
            Callable<R> other$procedure = other.getProcedure();
            if (this$procedure == null ? other$procedure != null : !this$procedure.equals(other$procedure)) {
                return false;
            }
            R this$procedureResult = this.getProcedureResult();
            R other$procedureResult = other.getProcedureResult();
            if (this$procedureResult == null ? other$procedureResult != null : !this$procedureResult.equals(other$procedureResult)) {
                return false;
            }
            Function<WaitForStateCommand<R>, Boolean> this$checkDoneFunc = this.getCheckDoneFunc();
            Function<WaitForStateCommand<R>, Boolean> other$checkDoneFunc = other.getCheckDoneFunc();
            if (this$checkDoneFunc == null ? other$checkDoneFunc != null : !this$checkDoneFunc.equals(other$checkDoneFunc)) {
                return false;
            }
            Throwable this$exception = this.getException();
            Throwable other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WaitForStateCommand;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIntervalSeconds();
            result = result * 59 + this.getTimeoutSeconds();
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            Callable<R> $procedure = this.getProcedure();
            result = result * 59 + ($procedure == null ? 43 : $procedure.hashCode());
            R $procedureResult = this.getProcedureResult();
            result = result * 59 + ($procedureResult == null ? 43 : $procedureResult.hashCode());
            Function<WaitForStateCommand<R>, Boolean> $checkDoneFunc = this.getCheckDoneFunc();
            result = result * 59 + ($checkDoneFunc == null ? 43 : $checkDoneFunc.hashCode());
            Throwable $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        public String toString() {
            return "ExecuteUtils.WaitForStateCommand(procedure=" + this.getProcedure() + ", procedureResult=" + this.getProcedureResult() + ", checkDoneFunc=" + this.getCheckDoneFunc() + ", intervalSeconds=" + this.getIntervalSeconds() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ", success=" + this.isSuccess() + ", exception=" + this.getException() + ")";
        }
    }

    public static class VOID {
    }

    public static abstract class HttpExecuteCommand<T>
    extends ExecuteCommand<T> {
        @Override
        public boolean isRetry(Exception e) {
            return true;
        }

        public void setHttpParams(HttpRequestBase request) {
        }

        public void setHttpEntity(HttpEntityEnclosingRequestBase request) {
        }

        public void setHttpConf(HttpRequestBase request) {
        }

        public void setHttpHeader(HttpRequestBase request) {
        }

        public void setHttpCredentials(HttpClientContext context) {
        }
    }

    public static class ExecuteException
    extends Exception {
        private static final long serialVersionUID = -7226665961824572062L;

        public ExecuteException() {
        }

        public ExecuteException(Exception e) {
            super(e);
        }

        public ExecuteException(String s) {
            super(s);
        }
    }
}

