/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.DefaultExecutor;
import guru.nidi.graphviz.service.SystemUtils;
import javax.annotation.Nullable;

public class CommandBuilder {
    private boolean shellWrapper;
    @Nullable
    private DefaultExecutor cmdExec;

    public CommandBuilder withShellWrapper(boolean shellWrapper) {
        this.shellWrapper = shellWrapper;
        return this;
    }

    public CommandBuilder withCommandExecutor(DefaultExecutor cmdExec) {
        this.cmdExec = cmdExec;
        return this;
    }

    public CommandRunner build() {
        return new CommandRunner(SystemUtils.getShellWrapperOrDefault(this.shellWrapper), CommandBuilder.getCmdExecutorOrDefault(this.cmdExec));
    }

    private static DefaultExecutor getCmdExecutorOrDefault(@Nullable DefaultExecutor cmdExec) {
        return cmdExec == null ? new DefaultExecutor() : cmdExec;
    }
}

