/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

public enum Format {
    PNG("svg", "png", true, true){

        @Override
        String postProcess(String result) {
            return Format.postProcessSvg(result);
        }
    }
    ,
    SVG("svg", "svg", false, true){

        @Override
        String postProcess(String result) {
            return Format.postProcessSvg(result);
        }
    }
    ,
    SVG_STANDALONE("svg", "svg", false, true),
    XDOT("xdot", "xdot", false, false),
    PLAIN("plain", "txt", false, false),
    PLAIN_EXT("plain-ext", "txt", false, false),
    PS("ps", "ps", false, false),
    PS2("ps2", "ps", false, false),
    JSON("json", "json", false, false),
    JSON0("json0", "json", false, false);

    final String vizName;
    final String fileExtension;
    final boolean image;
    final boolean svg;

    private Format(String vizName, String fileExtension, boolean image, boolean svg) {
        this.vizName = vizName;
        this.fileExtension = fileExtension;
        this.image = image;
        this.svg = svg;
    }

    String postProcess(String result) {
        return result;
    }

    private static String postProcessSvg(String result) {
        int pos = result.indexOf("<svg ");
        return pos < 0 ? result : result.substring(pos);
    }
}

