/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.sandbox;

import com.aliyun.securitysdk.sandbox.SandboxCallable;
import com.aliyun.securitysdk.sandbox.SandboxConfiguration;
import com.aliyun.securitysdk.sandbox.SandboxInterface;

public class Sandbox {
    private ThreadLocal<Long> sandboxId = new ThreadLocal();
    private SandboxConfiguration conf;

    public Sandbox() {
    }

    public Sandbox(SandboxConfiguration conf) {
        this.conf = conf;
    }

    public <T> T execute(SandboxCallable<T> callable) throws Exception {
        this.sandboxId.set(SandboxInterface.enterSandbox(this.conf));
        try {
            T t = callable.call();
            return t;
        }
        finally {
            SandboxInterface.exitSandbox(this.sandboxId.get());
        }
    }

    public SandboxConfiguration getConf() {
        return this.conf;
    }

    public void setConf(SandboxConfiguration conf) {
        this.conf = conf;
    }
}

