/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk;

import com.aliyun.securitysdk.SecurityUtil;
import com.aliyun.securitysdk.url.ssrf.http.SecurityRedirectStrategy;
import com.aliyun.securitysdk.util.ServiceLoaderUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.RedirectStrategy;

public class SecurityRedirectStrategies {
    public static RedirectStrategy getInstance(SecurityRedirectStrategy.CheckMethod checkMethod) {
        return RedirectStrategyHolder.SECURITY_REDIRECT_STRATEGY_MAP.get((Object)checkMethod);
    }

    private static class RedirectStrategyHolder {
        static final Iterator<SecurityRedirectStrategy> securityRedirectStrategies = ServiceLoaderUtil.newInstances(SecurityRedirectStrategy.class);
        static final Map<SecurityRedirectStrategy.CheckMethod, SecurityRedirectStrategy> SECURITY_REDIRECT_STRATEGY_MAP;

        private RedirectStrategyHolder() {
        }

        static {
            HashMap<SecurityRedirectStrategy.CheckMethod, SecurityRedirectStrategy> temp = new HashMap<SecurityRedirectStrategy.CheckMethod, SecurityRedirectStrategy>();
            while (securityRedirectStrategies.hasNext()) {
                SecurityRedirectStrategy strategy = securityRedirectStrategies.next();
                strategy.init(SecurityUtil.getSSRFCheckerSingleton());
                temp.put(strategy.getCheckMethod(), strategy);
            }
            SECURITY_REDIRECT_STRATEGY_MAP = Collections.unmodifiableMap(temp);
        }
    }
}

