/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TypedMapWrapper<K, V> {
    private final Map<K, V> map;

    public TypedMapWrapper(Map<K, V> map) {
        this.map = map;
    }

    public String getString(K key) {
        return this.getString(key, null);
    }

    public String getString(K key, String defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public Boolean getBool(K key, Boolean defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        return (Boolean)obj;
    }

    public Integer getInt(K key) {
        return this.getInt(key, -1);
    }

    public Integer getInt(K key, Integer defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        return defaultVal;
    }

    public Long getLong(K key) {
        return this.getLong(key, -1L);
    }

    public Long getLong(K key, Long defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            return (long)((Integer)obj);
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        return defaultVal;
    }

    public Double getDouble(K key) {
        return this.getDouble(key, -1.0);
    }

    public Double getDouble(K key, Double defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return defaultVal;
    }

    public Collection<String> getStringCollection(K key) {
        V obj = this.map.get(key);
        return (Collection)obj;
    }

    public Collection<String> getStringCollection(K key, Collection<String> defaultVal) {
        V obj = this.map.get(key);
        if (obj == null) {
            return defaultVal;
        }
        return (Collection)obj;
    }

    public <C> Collection<C> getCollection(K key) {
        V obj = this.map.get(key);
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        return null;
    }

    public <L> List<L> getList(K key) {
        V obj = this.map.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    public <L> List<L> getList(K key, List<L> defaultVal) {
        V obj = this.map.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return defaultVal;
    }

    public Object getObject(K key) {
        return this.map.get(key);
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public <S, T> Map<S, T> getMap(K key) {
        return (Map)this.map.get(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

