/*
 * Decompiled with CFR 0.152.
 */
package azkaban.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class User {
    private final String userid;
    private final Set<String> roles = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    private final HashMap<String, String> properties = new HashMap();
    private String email = "";
    private UserPermissions userPermissions;

    public User(String userid) {
        this.userid = userid;
    }

    public String getUserId() {
        return this.userid;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserPermissions getPermissions() {
        return this.userPermissions;
    }

    public void setPermissions(UserPermissions checker) {
        this.userPermissions = checker;
    }

    public boolean hasPermission(String permission) {
        if (this.userPermissions == null) {
            return false;
        }
        return this.userPermissions.hasPermission(permission);
    }

    public List<String> getGroups() {
        return new ArrayList<String>(this.groups);
    }

    public void clearGroup() {
        this.groups.clear();
    }

    public void addGroup(String name) {
        this.groups.add(name);
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public List<String> getRoles() {
        return new ArrayList<String>(this.roles);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        String groupStr = "[";
        for (String group : this.groups) {
            groupStr = groupStr + group + ",";
        }
        groupStr = groupStr + "]";
        return this.userid + ": " + groupStr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userid == null ? other.userid != null : !this.userid.equals(other.userid));
    }

    public static class DefaultUserPermission
    implements UserPermissions {
        Set<String> permissions;

        public DefaultUserPermission() {
            this(new HashSet<String>());
        }

        public DefaultUserPermission(Set<String> permissions) {
            this.permissions = permissions;
        }

        @Override
        public boolean hasPermission(String permission) {
            return this.permissions.contains(permission);
        }

        @Override
        public void addPermission(String permission) {
            this.permissions.add(permission);
        }
    }

    public static interface UserPermissions {
        public boolean hasPermission(String var1);

        public void addPermission(String var1);
    }
}

