/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.project.AzkabanProjectLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.FlowTrigger;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.project.ProjectWhitelist;
import azkaban.project.validator.ValidationReport;
import azkaban.project.validator.XmlValidatorManager;
import azkaban.storage.StorageManager;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.CaseInsensitiveConcurrentHashMap;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class ProjectManager {
    private static final Logger logger = Logger.getLogger(ProjectManager.class);
    private final AzkabanProjectLoader azkabanProjectLoader;
    private final ProjectLoader projectLoader;
    private final Props props;
    private final boolean creatorDefaultPermissions;
    private final ConcurrentHashMap<Integer, Project> projectsById = new ConcurrentHashMap();
    private final CaseInsensitiveConcurrentHashMap<Project> projectsByName = new CaseInsensitiveConcurrentHashMap();

    @Inject
    public ProjectManager(AzkabanProjectLoader azkabanProjectLoader, ProjectLoader loader, StorageManager storageManager, Props props) {
        this.projectLoader = Objects.requireNonNull(loader);
        this.props = Objects.requireNonNull(props);
        this.azkabanProjectLoader = Objects.requireNonNull(azkabanProjectLoader);
        this.creatorDefaultPermissions = props.getBoolean("creator.default.proxy", true);
        Props prop = new Props(props);
        prop.put("project.archive.file.path", "initialize");
        new XmlValidatorManager(prop);
        this.loadAllProjects();
        this.loadProjectWhiteList();
    }

    public boolean hasFlowTrigger(Project project, Flow flow) throws IOException, ProjectManagerException {
        String flowFileName = flow.getId() + ".flow";
        int latestFlowVersion = this.projectLoader.getLatestFlowVersion(project.getId(), flow.getVersion(), flowFileName);
        if (latestFlowVersion > 0) {
            File tempDir = Files.createTempDir();
            try {
                File flowFile = this.projectLoader.getUploadedFlowFile(project.getId(), project.getVersion(), flowFileName, latestFlowVersion, tempDir);
                FlowTrigger flowTrigger = FlowLoaderUtils.getFlowTriggerFromYamlFile(flowFile);
                boolean bl = flowTrigger != null;
                return bl;
            }
            catch (Exception ex) {
                logger.error((Object)"error in getting flow file", (Throwable)ex);
                throw ex;
            }
            finally {
                FlowLoaderUtils.cleanUpDir(tempDir);
            }
        }
        return false;
    }

    private void loadAllProjects() {
        List<Project> projects;
        try {
            projects = this.projectLoader.fetchAllActiveProjects();
        }
        catch (ProjectManagerException e) {
            throw new RuntimeException("Could not load projects from store.", (Throwable)((Object)e));
        }
        for (Project proj : projects) {
            this.projectsByName.put(proj.getName(), proj);
            this.projectsById.put(proj.getId(), proj);
        }
        for (Project proj : projects) {
            this.loadAllProjectFlows(proj);
        }
    }

    private void loadAllProjectFlows(Project project) {
        try {
            List<Flow> flows = this.projectLoader.fetchAllProjectFlows(project);
            HashMap<String, Flow> flowMap = new HashMap<String, Flow>();
            for (Flow flow : flows) {
                flowMap.put(flow.getId(), flow);
            }
            project.setFlows(flowMap);
        }
        catch (ProjectManagerException e) {
            throw new RuntimeException("Could not load projects flows from store.", (Throwable)((Object)e));
        }
    }

    public Props getProps() {
        return this.props;
    }

    public List<Project> getUserProjects(User user) {
        ArrayList<Project> array = new ArrayList<Project>();
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.READ)) continue;
            array.add(project);
        }
        return array;
    }

    public List<Project> getGroupProjects(User user) {
        ArrayList<Project> array = new ArrayList<Project>();
        for (Project project : this.projectsById.values()) {
            if (!project.hasGroupPermission(user, Permission.Type.READ)) continue;
            array.add(project);
        }
        return array;
    }

    public List<Project> getUserProjectsByRegex(User user, String regexPattern) {
        Pattern pattern;
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error((Object)("Bad regex pattern " + regexPattern));
            return array;
        }
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.READ) || !pattern.matcher(project.getName()).find()) continue;
            array.add(project);
        }
        return array;
    }

    public List<Project> getProjects() {
        return new ArrayList<Project>(this.projectsById.values());
    }

    public List<Project> getProjectsByRegex(String regexPattern) {
        Pattern pattern;
        ArrayList<Project> allProjects = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error((Object)("Bad regex pattern " + regexPattern));
            return allProjects;
        }
        for (Project project : this.getProjects()) {
            if (!pattern.matcher(project.getName()).find()) continue;
            allProjects.add(project);
        }
        return allProjects;
    }

    public Boolean isActiveProject(int id) {
        return this.projectsById.containsKey(id);
    }

    public Project getProject(String name) {
        Project fetchedProject = this.projectsByName.get(name);
        if (fetchedProject == null) {
            try {
                logger.info((Object)("Project " + name + " doesn't exist in cache, fetching from DB now."));
                fetchedProject = this.projectLoader.fetchProjectByName(name);
            }
            catch (ProjectManagerException e) {
                logger.error((Object)"Could not load project from store.", (Throwable)((Object)e));
            }
        }
        return fetchedProject;
    }

    public Project getProject(int id) {
        Project fetchedProject = this.projectsById.get(id);
        if (fetchedProject == null) {
            try {
                fetchedProject = this.projectLoader.fetchProjectById(id);
            }
            catch (ProjectManagerException e) {
                logger.error((Object)"Could not load project from store.", (Throwable)((Object)e));
            }
        }
        return fetchedProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(String projectName, String description, User creator) throws ProjectManagerException {
        Project newProject;
        if (projectName == null || projectName.trim().isEmpty()) {
            throw new ProjectManagerException("Project name cannot be empty.");
        }
        if (description == null || description.trim().isEmpty()) {
            throw new ProjectManagerException("Description cannot be empty.");
        }
        if (creator == null) {
            throw new ProjectManagerException("Valid creator user must be set.");
        }
        if (!projectName.matches("[a-zA-Z][a-zA-Z_0-9|-]*")) {
            throw new ProjectManagerException("Project names must start with a letter, followed by any number of letters, digits, '-' or '_'.");
        }
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (this.projectsByName.containsKey(projectName)) {
                throw new ProjectManagerException("Project already exists.");
            }
            logger.info((Object)("Trying to create " + projectName + " by user " + creator.getUserId()));
            newProject = this.projectLoader.createNewProject(projectName, description, creator);
            this.projectsByName.put(newProject.getName(), newProject);
            this.projectsById.put(newProject.getId(), newProject);
        }
        if (this.creatorDefaultPermissions) {
            this.projectLoader.updatePermission(newProject, creator.getUserId(), new Permission(Permission.Type.ADMIN), false);
            newProject.addProxyUser(creator.getUserId());
            try {
                this.updateProjectSetting(newProject);
            }
            catch (ProjectManagerException e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.projectLoader.postEvent(newProject, ProjectLogEvent.EventType.CREATED, creator.getUserId(), null);
        return newProject;
    }

    public synchronized Project purgeProject(Project project, User deleter) throws ProjectManagerException {
        this.projectLoader.cleanOlderProjectVersion(project.getId(), project.getVersion() + 1, Collections.emptyList());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PURGE, deleter.getUserId(), String.format("Purged versions before %d", project.getVersion() + 1));
        return project;
    }

    public synchronized Project removeProject(Project project, User deleter) throws ProjectManagerException {
        this.projectLoader.removeProject(project, deleter.getUserId());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.DELETED, deleter.getUserId(), null);
        this.projectsByName.remove(project.getName());
        this.projectsById.remove(project.getId());
        return project;
    }

    public void updateProjectDescription(Project project, String description, User modifier) throws ProjectManagerException {
        this.projectLoader.updateDescription(project, description, modifier.getUserId());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.DESCRIPTION, modifier.getUserId(), "Description changed to " + description);
    }

    public List<ProjectLogEvent> getProjectEventLogs(Project project, int results, int skip) throws ProjectManagerException {
        return this.projectLoader.getProjectEvents(project, results, skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Props getPropertiesFromFlowFile(Flow flow, String jobName, String flowFileName, int flowVersion) throws ProjectManagerException {
        File tempDir = null;
        Props props = null;
        try {
            tempDir = Files.createTempDir();
            File flowFile = this.projectLoader.getUploadedFlowFile(flow.getProjectId(), flow.getVersion(), flowFileName, flowVersion, tempDir);
            String path = jobName == null ? flow.getId() : flow.getId() + ":" + jobName;
            props = FlowLoaderUtils.getPropsFromYamlFile(path, flowFile);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get props from flow file. " + e));
        }
        finally {
            FlowLoaderUtils.cleanUpDir(tempDir);
        }
        return props;
    }

    public Props getProperties(Project project, Flow flow, String jobName, String source) throws ProjectManagerException {
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            return this.getPropertiesFromFlowFile(flow, jobName, source, 1);
        }
        return this.projectLoader.fetchProjectProperty(project, source);
    }

    public Props getJobOverrideProperty(Project project, Flow flow, String jobName, String source) throws ProjectManagerException {
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            int flowVersion = this.projectLoader.getLatestFlowVersion(flow.getProjectId(), flow.getVersion(), source);
            return this.getPropertiesFromFlowFile(flow, jobName, source, flowVersion);
        }
        return this.projectLoader.fetchProjectProperty(project, jobName + ".jor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobOverrideProperty(Project project, Flow flow, Props prop, String jobName, String source, User modifier) throws ProjectManagerException {
        File tempDir = null;
        Props oldProps = null;
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            try {
                tempDir = Files.createTempDir();
                int flowVersion = this.projectLoader.getLatestFlowVersion(flow.getProjectId(), flow.getVersion(), source);
                File flowFile = this.projectLoader.getUploadedFlowFile(flow.getProjectId(), flow.getVersion(), source, flowVersion, tempDir);
                String path = flow.getId() + ":" + jobName;
                oldProps = FlowLoaderUtils.getPropsFromYamlFile(path, flowFile);
                FlowLoaderUtils.setPropsInYamlFile(path, flowFile, prop);
                this.projectLoader.uploadFlowFile(flow.getProjectId(), flow.getVersion(), flowFile, flowVersion + 1);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to set job override property. " + e));
            }
            finally {
                FlowLoaderUtils.cleanUpDir(tempDir);
            }
        } else {
            prop.setSource(jobName + ".jor");
            oldProps = this.projectLoader.fetchProjectProperty(project, prop.getSource());
            if (oldProps == null) {
                this.projectLoader.uploadProjectProperty(project, prop);
            } else {
                this.projectLoader.updateProjectProperty(project, prop);
            }
        }
        String diffMessage = PropsUtils.getPropertyDiff((Props)oldProps, (Props)prop);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROPERTY_OVERRIDE, modifier.getUserId(), diffMessage);
    }

    public void updateProjectSetting(Project project) throws ProjectManagerException {
        this.projectLoader.updateProjectSettings(project);
    }

    public void addProjectProxyUser(Project project, String proxyName, User modifier) throws ProjectManagerException {
        logger.info((Object)("User " + modifier.getUserId() + " adding proxy user " + proxyName + " to project " + project.getName()));
        project.addProxyUser(proxyName);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROXY_USER, modifier.getUserId(), "Proxy user " + proxyName + " is added to project.");
        this.updateProjectSetting(project);
    }

    public void removeProjectProxyUser(Project project, String proxyName, User modifier) throws ProjectManagerException {
        logger.info((Object)("User " + modifier.getUserId() + " removing proxy user " + proxyName + " from project " + project.getName()));
        project.removeProxyUser(proxyName);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROXY_USER, modifier.getUserId(), "Proxy user " + proxyName + " has been removed form the project.");
        this.updateProjectSetting(project);
    }

    public void updateProjectPermission(Project project, String name, Permission perm, boolean group, User modifier) throws ProjectManagerException {
        logger.info((Object)("User " + modifier.getUserId() + " updating permissions for project " + project.getName() + " for " + name + " " + perm.toString()));
        this.projectLoader.updatePermission(project, name, perm, group);
        if (group) {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.GROUP_PERMISSION, modifier.getUserId(), "Permission for group " + name + " set to " + perm.toString());
        } else {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.USER_PERMISSION, modifier.getUserId(), "Permission for user " + name + " set to " + perm.toString());
        }
    }

    public void removeProjectPermission(Project project, String name, boolean group, User modifier) throws ProjectManagerException {
        logger.info((Object)("User " + modifier.getUserId() + " removing permissions for project " + project.getName() + " for " + name));
        this.projectLoader.removePermission(project, name, group);
        if (group) {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.GROUP_PERMISSION, modifier.getUserId(), "Permission for group " + name + " removed.");
        } else {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.USER_PERMISSION, modifier.getUserId(), "Permission for user " + name + " removed.");
        }
    }

    public ProjectFileHandler getProjectFileHandler(Project project, int version) throws ProjectManagerException {
        return this.azkabanProjectLoader.getProjectFile(project, version);
    }

    public Map<String, ValidationReport> uploadProject(Project project, File archive, String fileType, User uploader, Props additionalProps) throws ProjectManagerException, ExecutorManagerException {
        return this.azkabanProjectLoader.uploadProject(project, archive, fileType, uploader, additionalProps);
    }

    public void updateFlow(Project project, Flow flow) throws ProjectManagerException {
        this.projectLoader.updateFlow(project, flow.getVersion(), flow);
    }

    public void postProjectEvent(Project project, ProjectLogEvent.EventType type, String user, String message) {
        this.projectLoader.postEvent(project, type, user, message);
    }

    public boolean loadProjectWhiteList() {
        if (this.props.containsKey((Object)"project.whitelist.xml.file")) {
            ProjectWhitelist.load(this.props);
            return true;
        }
        return false;
    }
}

