/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype;

import azkaban.jobExecutor.Job;
import azkaban.utils.Props;
import java.util.HashMap;
import java.util.Map;

public class JobTypePluginSet {
    private final Map<String, Class<? extends Job>> jobToClass;
    private final Map<String, Props> pluginJobPropsMap;
    private final Map<String, Props> pluginLoadPropsMap;
    private Props commonJobProps;
    private Props commonLoadProps;

    public JobTypePluginSet() {
        this.jobToClass = new HashMap<String, Class<? extends Job>>();
        this.pluginJobPropsMap = new HashMap<String, Props>();
        this.pluginLoadPropsMap = new HashMap<String, Props>();
    }

    public JobTypePluginSet(JobTypePluginSet clone) {
        this.jobToClass = new HashMap<String, Class<? extends Job>>(clone.jobToClass);
        this.pluginJobPropsMap = new HashMap<String, Props>(clone.pluginJobPropsMap);
        this.pluginLoadPropsMap = new HashMap<String, Props>(clone.pluginLoadPropsMap);
        this.commonJobProps = clone.commonJobProps;
        this.commonLoadProps = clone.commonLoadProps;
    }

    public Props getCommonPluginJobProps() {
        return this.commonJobProps;
    }

    public void setCommonPluginJobProps(Props commonJobProps) {
        this.commonJobProps = commonJobProps;
    }

    public Props getCommonPluginLoadProps() {
        return this.commonLoadProps;
    }

    public void setCommonPluginLoadProps(Props commonLoadProps) {
        this.commonLoadProps = commonLoadProps;
    }

    public Props getPluginLoaderProps(String jobTypeName) {
        return this.pluginLoadPropsMap.get(jobTypeName);
    }

    public Props getPluginJobProps(String jobTypeName) {
        return this.pluginJobPropsMap.get(jobTypeName);
    }

    public Class<? extends Job> getPluginClass(String jobTypeName) {
        return this.jobToClass.get(jobTypeName);
    }

    public void addPluginClass(String jobTypeName, Class<? extends Job> jobTypeClass) {
        this.jobToClass.put(jobTypeName, jobTypeClass);
    }

    public void addPluginJobProps(String jobTypeName, Props props) {
        this.pluginJobPropsMap.put(jobTypeName, props);
    }

    public void addPluginLoadProps(String jobTypeName, Props props) {
        this.pluginLoadPropsMap.put(jobTypeName, props);
    }
}

