/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor.utils.process;

import azkaban.jobExecutor.utils.process.AzkabanProcess;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AzkabanProcessBuilder {
    private final List<String> cmd = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private String workingDir = System.getProperty("user.dir");
    private Logger logger = Logger.getLogger(AzkabanProcess.class);
    private boolean isExecuteAsUser = false;
    private String executeAsUserBinaryPath = null;
    private String effectiveUser = null;
    private int stdErrSnippetSize = 30;
    private int stdOutSnippetSize = 30;

    public AzkabanProcessBuilder(String ... command) {
        this.addArg(command);
    }

    public AzkabanProcessBuilder addArg(String ... command) {
        for (String c : command) {
            this.cmd.add(c);
        }
        return this;
    }

    public AzkabanProcessBuilder setWorkingDir(String dir) {
        this.workingDir = dir;
        return this;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public AzkabanProcessBuilder setWorkingDir(File f) {
        return this.setWorkingDir(f.getAbsolutePath());
    }

    public AzkabanProcessBuilder addEnv(String variable, String value) {
        this.env.put(variable, value);
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public AzkabanProcessBuilder setEnv(Map<String, String> m) {
        this.env = m;
        return this;
    }

    public int getStdErrorSnippetSize() {
        return this.stdErrSnippetSize;
    }

    public AzkabanProcessBuilder setStdErrorSnippetSize(int size) {
        this.stdErrSnippetSize = size;
        return this;
    }

    public int getStdOutSnippetSize() {
        return this.stdOutSnippetSize;
    }

    public AzkabanProcessBuilder setStdOutSnippetSize(int size) {
        this.stdOutSnippetSize = size;
        return this;
    }

    public AzkabanProcessBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public AzkabanProcess build() {
        if (this.isExecuteAsUser) {
            return new AzkabanProcess(this.cmd, this.env, this.workingDir, this.logger, this.executeAsUserBinaryPath, this.effectiveUser);
        }
        return new AzkabanProcess(this.cmd, this.env, this.workingDir, this.logger);
    }

    public List<String> getCommand() {
        return this.cmd;
    }

    public String getCommandString() {
        return Joiner.on((String)" ").join(this.getCommand());
    }

    public String toString() {
        return "ProcessBuilder(cmd = " + Joiner.on((String)" ").join(this.cmd) + ", env = " + this.env + ", cwd = " + this.workingDir + ")";
    }

    public AzkabanProcessBuilder enableExecuteAsUser() {
        this.isExecuteAsUser = true;
        return this;
    }

    public AzkabanProcessBuilder setExecuteAsUserBinaryPath(String executeAsUserBinaryPath) {
        this.executeAsUserBinaryPath = executeAsUserBinaryPath;
        return this;
    }

    public AzkabanProcessBuilder setEffectiveUser(String effectiveUser) {
        this.effectiveUser = effectiveUser;
        return this;
    }
}

