/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.selector.CandidateComparator;
import java.util.Comparator;
import org.apache.log4j.Logger;

public final class FactorComparator<T> {
    private static final Logger logger = Logger.getLogger(CandidateComparator.class);
    private final String factorName;
    private final Comparator<T> comparator;
    private int weight;

    private FactorComparator(String factorName, int weight, Comparator<T> comparator) {
        this.factorName = factorName;
        this.weight = weight;
        this.comparator = comparator;
    }

    public static <T> FactorComparator<T> create(String factorName, int weight, Comparator<T> comparator) {
        if (null == factorName || factorName.length() == 0 || weight < 0 || null == comparator) {
            logger.error((Object)"failed to create instance of FactorComparator, at least one of the input paramters are invalid");
            return null;
        }
        return new FactorComparator<T>(factorName, weight, comparator);
    }

    public String getFactorName() {
        return this.factorName;
    }

    public int getWeight() {
        return this.weight;
    }

    public void updateWeight(int value) {
        this.weight = value;
    }

    public int compare(T object1, T object2) {
        return this.comparator.compare(object1, object2);
    }
}

