/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.selector.FactorComparator;
import azkaban.utils.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class CandidateComparator<T>
implements Comparator<T> {
    protected static Logger logger = Logger.getLogger(CandidateComparator.class);
    private final Map<String, FactorComparator<T>> factorComparatorList = new ConcurrentHashMap<String, FactorComparator<T>>();

    public abstract String getName();

    protected boolean tieBreak(T object1, T object2) {
        if (null == object2) {
            return true;
        }
        if (null == object1) {
            return false;
        }
        return object1.hashCode() >= object2.hashCode();
    }

    protected void registerFactorComparator(FactorComparator<T> comparator) {
        if (null == comparator || Integer.MAX_VALUE - this.getTotalWeight() < comparator.getWeight()) {
            throw new IllegalArgumentException("unable to register comparator. The passed comparator is null or has an invalid weight value.");
        }
        this.factorComparatorList.put(comparator.getFactorName(), comparator);
        logger.debug((Object)String.format("Factor comparator added for '%s'. Weight = '%s'", comparator.getFactorName(), comparator.getWeight()));
    }

    public int getTotalWeight() {
        int totalWeight = 0;
        Collection<FactorComparator<T>> allValues = this.factorComparatorList.values();
        for (FactorComparator<T> item : allValues) {
            if (item == null) continue;
            totalWeight += item.getWeight();
        }
        return totalWeight;
    }

    public Pair<Integer, Integer> getComparisonScore(T object1, T object2) {
        logger.debug((Object)String.format("start comparing '%s' with '%s',  total weight = %s ", object1 == null ? "(null)" : object1.toString(), object2 == null ? "(null)" : object2.toString(), this.getTotalWeight()));
        int result1 = 0;
        int result2 = 0;
        if (object1 == object2) {
            logger.debug((Object)"[Comparator] same object.");
        } else if (object1 == null) {
            logger.debug((Object)"[Comparator] left side is null, right side gets total weight.");
            result2 = this.getTotalWeight();
        } else if (object2 == null) {
            logger.debug((Object)"[Comparator] right side is null, left side gets total weight.");
            result1 = this.getTotalWeight();
        } else {
            Collection<FactorComparator<T>> comparatorList = this.factorComparatorList.values();
            Iterator<FactorComparator<T>> iterator = comparatorList.iterator();
            while (iterator.hasNext()) {
                int result;
                FactorComparator<T> comparator;
                logger.debug((Object)String.format("[Factor: %s] compare result : %s (current score %s vs %s)", comparator.getFactorName(), result, result1 += (result = (comparator = iterator.next()).compare(object1, object2)) > 0 ? comparator.getWeight() : 0, result2 += result < 0 ? comparator.getWeight() : 0));
            }
        }
        if (result1 == result2) {
            boolean result = this.tieBreak(object1, object2);
            logger.debug((Object)("[TieBreaker] TieBreaker chose " + (result ? String.format("left side (%s)", null == object1 ? "null" : object1.toString()) : String.format("right side (%s)", null == object2 ? "null" : object2.toString()))));
            if (result) {
                ++result1;
            } else {
                ++result2;
            }
        }
        logger.debug((Object)String.format("Result : %s vs %s ", result1, result2));
        return new Pair<Integer, Integer>(result1, result2);
    }

    @Override
    public int compare(T o1, T o2) {
        Pair<Integer, Integer> result = this.getComparisonScore(o1, o2);
        return Objects.equals(result.getFirst(), result.getSecond()) ? 0 : (result.getFirst() > result.getSecond() ? 1 : -1);
    }
}

