/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.RunningExecutions;
import azkaban.executor.RunningExecutionsUpdater;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class RunningExecutionsUpdaterThread
extends Thread {
    private static final Logger logger = Logger.getLogger(RunningExecutionsUpdaterThread.class);
    volatile int waitTimeIdleMs = 2000;
    volatile int waitTimeMs = 500;
    private final RunningExecutionsUpdater updater;
    private final RunningExecutions runningExecutions;
    private long lastThreadCheckTime = -1L;
    private boolean shutdown = false;

    @Inject
    public RunningExecutionsUpdaterThread(RunningExecutionsUpdater updater, RunningExecutions runningExecutions) {
        this.updater = updater;
        this.runningExecutions = runningExecutions;
        this.setName("ExecutorManagerUpdaterThread");
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.lastThreadCheckTime = System.currentTimeMillis();
                this.updater.updateExecutions();
                this.waitForNewExecutions();
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected exception in updating executions", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNewExecutions() {
        RunningExecutions runningExecutions = this.runningExecutions;
        synchronized (runningExecutions) {
            try {
                int waitTimeMillis;
                int n = waitTimeMillis = this.runningExecutions.get().size() > 0 ? this.waitTimeMs : this.waitTimeIdleMs;
                if (waitTimeMillis > 0) {
                    this.runningExecutions.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void shutdown() {
        this.shutdown = true;
    }

    public long getLastThreadCheckTime() {
        return this.lastThreadCheckTime;
    }
}

