/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.event.EventHandler;
import azkaban.executor.ActiveExecutors;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionFinalizer;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorApiGateway;
import azkaban.executor.ExecutorInfo;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.ExecutorManagerUpdaterStage;
import azkaban.executor.QueuedExecutions;
import azkaban.executor.RunningExecutions;
import azkaban.executor.RunningExecutionsUpdaterThread;
import azkaban.executor.Status;
import azkaban.executor.selector.ExecutorComparator;
import azkaban.executor.selector.ExecutorFilter;
import azkaban.executor.selector.ExecutorSelector;
import azkaban.flow.FlowUtils;
import azkaban.metrics.CommonMetrics;
import azkaban.project.Project;
import azkaban.project.ProjectWhitelist;
import azkaban.utils.AuthenticationUtils;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

@Singleton
public class ExecutorManager
extends EventHandler
implements ExecutorManagerAdapter {
    private static final String SPARK_JOB_TYPE = "spark";
    private static final String APPLICATION_ID = "${application.id}";
    private static final Pattern APPLICATION_ID_PATTERN = Pattern.compile("application_\\d+_\\d+");
    private static final Pattern FAILED_TO_READ_APPLICATION_PATTERN = Pattern.compile("Failed to read the application");
    private static final Pattern INVALID_APPLICATION_ID_PATTERN = Pattern.compile("Invalid Application ID");
    private static final int DEFAULT_MAX_ONCURRENT_RUNS_ONEFLOW = 30;
    private static final long DEFAULT_EXECUTION_LOGS_RETENTION_MS = 7257600000L;
    private static final Duration RECENTLY_FINISHED_LIFETIME = Duration.ofMinutes(10L);
    private static final Logger logger = Logger.getLogger(ExecutorManager.class);
    private final RunningExecutions runningExecutions;
    private final Props azkProps;
    private final CommonMetrics commonMetrics;
    private final ExecutorLoader executorLoader;
    private final CleanerThread cleanerThread;
    private final RunningExecutionsUpdaterThread updaterThread;
    private final ExecutorApiGateway apiGateway;
    private final int maxConcurrentRunsOneFlow;
    private final ExecutorManagerUpdaterStage updaterStage;
    private final ExecutionFinalizer executionFinalizer;
    private final ActiveExecutors activeExecutors;
    private final ExecutorService executorInfoRefresherService;
    QueuedExecutions queuedFlows;
    File cacheDir;
    private QueueProcessorThread queueProcessor;
    private volatile Pair<ExecutionReference, ExecutableFlow> runningCandidate = null;
    private List<String> filterList;
    private Map<String, Integer> comparatorWeightsMap;
    private long lastSuccessfulExecutorInfoRefresh;
    private Duration sleepAfterDispatchFailure = Duration.ofSeconds(1L);
    private boolean initialized = false;

    @Inject
    public ExecutorManager(Props azkProps, ExecutorLoader executorLoader, CommonMetrics commonMetrics, ExecutorApiGateway apiGateway, RunningExecutions runningExecutions, ActiveExecutors activeExecutors, ExecutorManagerUpdaterStage updaterStage, ExecutionFinalizer executionFinalizer, RunningExecutionsUpdaterThread updaterThread) throws ExecutorManagerException {
        this.azkProps = azkProps;
        this.commonMetrics = commonMetrics;
        this.executorLoader = executorLoader;
        this.apiGateway = apiGateway;
        this.runningExecutions = runningExecutions;
        this.activeExecutors = activeExecutors;
        this.updaterStage = updaterStage;
        this.executionFinalizer = executionFinalizer;
        this.updaterThread = updaterThread;
        this.maxConcurrentRunsOneFlow = this.getMaxConcurrentRunsOneFlow(azkProps);
        this.cleanerThread = this.createCleanerThread();
        this.executorInfoRefresherService = this.createExecutorInfoRefresherService();
    }

    private int getMaxConcurrentRunsOneFlow(Props azkProps) {
        return azkProps.getInt("azkaban.max.concurrent.runs.oneflow", 30);
    }

    private CleanerThread createCleanerThread() {
        long executionLogsRetentionMs = this.azkProps.getLong("execution.logs.retention.ms", 7257600000L);
        return new CleanerThread(executionLogsRetentionMs);
    }

    void initialize() throws ExecutorManagerException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setupExecutors();
        this.loadRunningExecutions();
        this.queuedFlows = new QueuedExecutions(this.azkProps.getLong("azkaban.webserver.queue.size", 100000L));
        this.loadQueuedFlows();
        this.cacheDir = new File(this.azkProps.getString("cache.directory", "cache"));
        this.setupExecutotrComparatorWeightsMap();
        this.setupExecutorFilterList();
        this.queueProcessor = this.setupQueueProcessor();
    }

    @Override
    public void start() throws ExecutorManagerException {
        this.initialize();
        this.updaterThread.start();
        this.cleanerThread.start();
        this.queueProcessor.start();
    }

    private String findApplicationIdFromLog(String logData) {
        Matcher matcher = APPLICATION_ID_PATTERN.matcher(logData);
        String appId = null;
        if (matcher.find()) {
            appId = matcher.group().substring(12);
        }
        logger.info((Object)("Application ID is " + appId));
        return appId;
    }

    private QueueProcessorThread setupQueueProcessor() {
        return new QueueProcessorThread(this.azkProps.getBoolean("azkaban.queueprocessing.enabled", true), this.azkProps.getLong("azkaban.activeexecutor.refresh.milisecinterval", 50000L), this.azkProps.getInt("azkaban.activeexecutor.refresh.flowinterval", 5), this.azkProps.getInt("azkaban.maxDispatchingErrors", this.activeExecutors.getAll().size()), this.sleepAfterDispatchFailure);
    }

    private void setupExecutotrComparatorWeightsMap() {
        Map compListStrings = this.azkProps.getMapByPrefix("azkaban.executorselector.comparator.");
        if (compListStrings != null) {
            this.comparatorWeightsMap = new TreeMap<String, Integer>();
            for (Map.Entry entry : compListStrings.entrySet()) {
                this.comparatorWeightsMap.put((String)entry.getKey(), Integer.valueOf((String)entry.getValue()));
            }
        }
    }

    private void setupExecutorFilterList() {
        String filters = this.azkProps.getString("azkaban.executorselector.filters", "");
        if (filters != null) {
            this.filterList = Arrays.asList(StringUtils.split((String)filters, (String)","));
        }
    }

    private ExecutorService createExecutorInfoRefresherService() {
        return Executors.newFixedThreadPool(this.azkProps.getInt("azkaban.executorinfo.refresh.maxThreads", 5));
    }

    @Override
    public void setupExecutors() throws ExecutorManagerException {
        this.checkMultiExecutorMode();
        this.activeExecutors.setupExecutors();
    }

    @Deprecated
    private void checkMultiExecutorMode() {
        if (!this.azkProps.getBoolean("azkaban.use.multiple.executors", false)) {
            throw new IllegalArgumentException("azkaban.use.multiple.executors must be true. Single executor mode is not supported any more.");
        }
    }

    private void refreshExecutors() {
        ArrayList<Pair<Executor, Future<ExecutorInfo>>> futures = new ArrayList<Pair<Executor, Future<ExecutorInfo>>>();
        for (Executor executor : this.activeExecutors.getAll()) {
            Future<ExecutorInfo> future = this.executorInfoRefresherService.submit(() -> this.apiGateway.callForJsonType(executor.getHost(), executor.getPort(), "/serverStatistics", null, ExecutorInfo.class));
            futures.add(new Pair<Executor, Future<ExecutorInfo>>(executor, future));
        }
        boolean wasSuccess = true;
        for (Pair pair : futures) {
            Executor executor = (Executor)pair.getFirst();
            executor.setExecutorInfo(null);
            try {
                ExecutorInfo executorInfo = (ExecutorInfo)((Future)pair.getSecond()).get(5L, TimeUnit.SECONDS);
                executor.setExecutorInfo(executorInfo);
                logger.info((Object)String.format("Successfully refreshed executor: %s with executor info : %s", executor, executorInfo));
            }
            catch (TimeoutException e) {
                wasSuccess = false;
                logger.error((Object)("Timed out while waiting for ExecutorInfo refresh" + executor), (Throwable)e);
            }
            catch (Exception e) {
                wasSuccess = false;
                logger.error((Object)("Failed to update ExecutorInfo for executor : " + executor), (Throwable)e);
            }
            if (!wasSuccess) continue;
            this.lastSuccessfulExecutorInfoRefresh = System.currentTimeMillis();
        }
    }

    @Override
    public void disableQueueProcessorThread() {
        this.queueProcessor.setActive(false);
    }

    @Override
    public void enableQueueProcessorThread() {
        this.queueProcessor.setActive(true);
    }

    public Thread.State getQueueProcessorThreadState() {
        return this.queueProcessor.getState();
    }

    public boolean isQueueProcessorThreadActive() {
        return this.queueProcessor.isActive();
    }

    public long getLastSuccessfulExecutorInfoRefresh() {
        return this.lastSuccessfulExecutorInfoRefresh;
    }

    public Set<String> getAvailableExecutorComparatorNames() {
        return ExecutorComparator.getAvailableComparatorNames();
    }

    public Set<String> getAvailableExecutorFilterNames() {
        return ExecutorFilter.getAvailableFilterNames();
    }

    @Override
    public Thread.State getExecutorManagerThreadState() {
        return this.updaterThread.getState();
    }

    public String getExecutorThreadStage() {
        return this.updaterStage.get();
    }

    @Override
    public boolean isExecutorManagerThreadActive() {
        return this.updaterThread.isAlive();
    }

    @Override
    public long getLastExecutorManagerThreadCheckTime() {
        return this.updaterThread.getLastThreadCheckTime();
    }

    @Override
    public Collection<Executor> getAllActiveExecutors() {
        return Collections.unmodifiableCollection(this.activeExecutors.getAll());
    }

    @Override
    public Executor fetchExecutor(int executorId) throws ExecutorManagerException {
        for (Executor executor : this.activeExecutors.getAll()) {
            if (executor.getId() != executorId) continue;
            return executor;
        }
        return this.executorLoader.fetchExecutor(executorId);
    }

    public Set<String> getPrimaryServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        for (Executor executor : this.activeExecutors.getAll()) {
            ports.add(executor.getHost() + ":" + executor.getPort());
        }
        return ports;
    }

    @Override
    public Set<String> getAllActiveExecutorServerHosts() {
        HashSet<String> ports = new HashSet<String>();
        for (Executor executor : this.activeExecutors.getAll()) {
            ports.add(executor.getHost() + ":" + executor.getPort());
        }
        for (Pair pair : this.runningExecutions.get().values()) {
            ExecutionReference ref = (ExecutionReference)pair.getFirst();
            if (!ref.getExecutor().isPresent()) continue;
            Executor executor = ref.getExecutor().get();
            ports.add(executor.getHost() + ":" + executor.getPort());
        }
        return ports;
    }

    private void loadRunningExecutions() throws ExecutorManagerException {
        logger.info((Object)"Loading running flows from database..");
        Map<Integer, Pair<ExecutionReference, ExecutableFlow>> activeFlows = this.executorLoader.fetchActiveFlows();
        logger.info((Object)("Loaded " + activeFlows.size() + " running flows"));
        this.runningExecutions.get().putAll(activeFlows);
    }

    private void loadQueuedFlows() throws ExecutorManagerException {
        List<Pair<ExecutionReference, ExecutableFlow>> retrievedExecutions = this.executorLoader.fetchQueuedFlows();
        if (retrievedExecutions != null) {
            for (Pair<ExecutionReference, ExecutableFlow> pair : retrievedExecutions) {
                this.queuedFlows.enqueue(pair.getSecond(), pair.getFirst());
            }
        }
    }

    @Override
    public List<Integer> getRunningFlows(int projectId, String flowId) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        executionIds.addAll(this.getRunningFlowsHelper(projectId, flowId, this.queuedFlows.getAllEntries()));
        if (this.runningCandidate != null) {
            executionIds.addAll(this.getRunningFlowsHelper(projectId, flowId, Lists.newArrayList((Object[])new Pair[]{this.runningCandidate})));
        }
        executionIds.addAll(this.getRunningFlowsHelper(projectId, flowId, this.runningExecutions.get().values()));
        Collections.sort(executionIds);
        return executionIds;
    }

    private List<Integer> getRunningFlowsHelper(int projectId, String flowId, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        ArrayList<Integer> executionIds = new ArrayList<Integer>();
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            if (!ref.getSecond().getFlowId().equals(flowId) || ref.getSecond().getProjectId() != projectId) continue;
            executionIds.add(ref.getFirst().getExecId());
        }
        return executionIds;
    }

    @Override
    public List<Pair<ExecutableFlow, Optional<Executor>>> getActiveFlowsWithExecutor() throws IOException {
        ArrayList<Pair<ExecutableFlow, Optional<Executor>>> flows = new ArrayList<Pair<ExecutableFlow, Optional<Executor>>>();
        this.getActiveFlowsWithExecutorHelper(flows, this.queuedFlows.getAllEntries());
        this.getActiveFlowsWithExecutorHelper(flows, this.runningExecutions.get().values());
        return flows;
    }

    private void getActiveFlowsWithExecutorHelper(List<Pair<ExecutableFlow, Optional<Executor>>> flows, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            flows.add(new Pair<ExecutableFlow, Optional<Executor>>(ref.getSecond(), ref.getFirst().getExecutor()));
        }
    }

    @Override
    public boolean isFlowRunning(int projectId, String flowId) {
        boolean isRunning = false;
        isRunning = isRunning || this.isFlowRunningHelper(projectId, flowId, this.queuedFlows.getAllEntries());
        isRunning = isRunning || this.isFlowRunningHelper(projectId, flowId, this.runningExecutions.get().values());
        return isRunning;
    }

    private boolean isFlowRunningHelper(int projectId, String flowId, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            if (ref.getSecond().getProjectId() != projectId || !ref.getSecond().getFlowId().equals(flowId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutableFlow getExecutableFlow(int execId) throws ExecutorManagerException {
        return this.executorLoader.fetchExecutableFlow(execId);
    }

    @Override
    public List<ExecutableFlow> getRunningFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList<ExecutableFlow>();
        this.getActiveFlowHelper(flows, this.queuedFlows.getAllEntries());
        this.getActiveFlowHelper(flows, this.runningExecutions.get().values());
        return flows;
    }

    private void getActiveFlowHelper(ArrayList<ExecutableFlow> flows, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            flows.add(ref.getSecond());
        }
    }

    public String getRunningFlowIds() {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        this.getRunningFlowsIdsHelper(allIds, this.queuedFlows.getAllEntries());
        this.getRunningFlowsIdsHelper(allIds, this.runningExecutions.get().values());
        Collections.sort(allIds);
        return ((Object)allIds).toString();
    }

    public String getQueuedFlowIds() {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        this.getRunningFlowsIdsHelper(allIds, this.queuedFlows.getAllEntries());
        Collections.sort(allIds);
        return ((Object)allIds).toString();
    }

    @Override
    public long getQueuedFlowSize() {
        return this.queuedFlows.size();
    }

    private void getRunningFlowsIdsHelper(List<Integer> allIds, Collection<Pair<ExecutionReference, ExecutableFlow>> collection) {
        for (Pair<ExecutionReference, ExecutableFlow> ref : collection) {
            allIds.add(ref.getSecond().getExecutionId());
        }
    }

    @Override
    public List<ExecutableFlow> getRecentlyFinishedFlows() {
        ArrayList<ExecutableFlow> flows = new ArrayList();
        try {
            flows = this.executorLoader.fetchRecentlyFinishedFlows(RECENTLY_FINISHED_LIFETIME);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Failed to fetch recently finished flows.", (Throwable)e);
        }
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String flowIdContains, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(null, '%' + flowIdContains + '%', null, 0, -1L, -1L, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(String projContain, String flowContain, String userContain, int status, long begin, long end, int skip, int size) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projContain, flowContain, userContain, status, begin, end, skip, size);
        return flows;
    }

    @Override
    public List<ExecutableJobInfo> getExecutableJobs(Project project, String jobId, int skip, int size) throws ExecutorManagerException {
        List<ExecutableJobInfo> nodes = this.executorLoader.fetchJobHistory(project.getId(), jobId, skip, size);
        return nodes;
    }

    @Override
    public int getNumberOfJobExecutions(Project project, String jobId) throws ExecutorManagerException {
        return this.executorLoader.fetchNumExecutableNodes(project.getId(), jobId);
    }

    @Override
    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow exFlow, int offset, int length) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "flow");
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "log", typeParam, offsetParam, lengthParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), "", 0, offset, length);
        return value;
    }

    @Override
    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow exFlow, String jobId, int offset, int length, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
        if (pair != null) {
            Pair<String, String> typeParam = new Pair<String, String>("type", "job");
            Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
            Pair<String, String> offsetParam = new Pair<String, String>("offset", String.valueOf(offset));
            Pair<String, String> lengthParam = new Pair<String, String>("length", String.valueOf(length));
            Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
            Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "log", typeParam, jobIdParam, offsetParam, lengthParam, attemptParam);
            return FileIOUtils.LogData.createLogDataFromObject(result);
        }
        FileIOUtils.LogData value = this.executorLoader.fetchLogs(exFlow.getExecutionId(), jobId, attempt, offset, length);
        return value;
    }

    @Override
    public List<Object> getExecutionJobStats(ExecutableFlow exFlow, String jobId, int attempt) throws ExecutorManagerException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
        if (pair == null) {
            return this.executorLoader.fetchAttachments(exFlow.getExecutionId(), jobId, attempt);
        }
        Pair<String, String> jobIdParam = new Pair<String, String>("jobId", jobId);
        Pair<String, String> attemptParam = new Pair<String, String>("attempt", String.valueOf(attempt));
        Map<String, Object> result = this.apiGateway.callWithReference(pair.getFirst(), "attachments", jobIdParam, attemptParam);
        List jobStats = (List)result.get("attachments");
        return jobStats;
    }

    @Override
    public String getJobLinkUrl(ExecutableFlow exFlow, String jobId, int attempt) {
        URL url;
        if (!(this.azkProps.containsKey((Object)"azkaban.server.external.resource_manager_job_url") && this.azkProps.containsKey((Object)"azkaban.server.external.history_server_job_url") && this.azkProps.containsKey((Object)"azkaban.server.external.spark_history_server_job_url"))) {
            return null;
        }
        String applicationId = this.getApplicationId(exFlow, jobId, attempt);
        if (applicationId == null) {
            return null;
        }
        boolean isRMJobLinkValid = true;
        try {
            url = new URL(this.azkProps.getString("azkaban.server.external.resource_manager_job_url").replace(APPLICATION_ID, applicationId));
            String keytabPrincipal = Objects.requireNonNull(this.azkProps.getString("azkaban.kerberos.principal"));
            String keytabPath = Objects.requireNonNull(this.azkProps.getString("azkaban.keytab.path"));
            HttpURLConnection connection = AuthenticationUtils.loginAuthenticatedURL(url, keytabPrincipal, keytabPath);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    if (!FAILED_TO_READ_APPLICATION_PATTERN.matcher(inputLine).find() && !INVALID_APPLICATION_ID_PATTERN.matcher(inputLine).find()) continue;
                    logger.info((Object)("RM job link is invalid or has expired for application_" + applicationId));
                    isRMJobLinkValid = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get job link for application_" + applicationId), (Throwable)e);
            return null;
        }
        String jobLinkUrl = isRMJobLinkValid ? url.toString() : (exFlow.getExecutableNode(jobId).getType().equals(SPARK_JOB_TYPE) ? this.azkProps.get((Object)"azkaban.server.external.spark_history_server_job_url").replace(APPLICATION_ID, applicationId) : this.azkProps.get((Object)"azkaban.server.external.history_server_job_url").replace(APPLICATION_ID, applicationId));
        logger.info((Object)("Job link url is " + jobLinkUrl + " for execution " + exFlow.getExecutionId() + ", job " + jobId));
        return jobLinkUrl;
    }

    private String getApplicationId(ExecutableFlow exFlow, String jobId, int attempt) {
        boolean finished = false;
        int offset = 0;
        try {
            while (!finished) {
                FileIOUtils.LogData data = this.getExecutionJobLog(exFlow, jobId, offset, 50000, attempt);
                if (data != null) {
                    String applicationId = this.findApplicationIdFromLog(data.getData());
                    if (applicationId != null) {
                        return applicationId;
                    }
                    offset = data.getOffset() + data.getLength();
                    logger.info((Object)("Get application ID for execution " + exFlow.getExecutionId() + ", job " + jobId + ", attempt " + attempt + ", data offset " + offset));
                    continue;
                }
                finished = true;
            }
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)("Failed to get application ID for execution " + exFlow.getExecutionId() + ", job " + jobId + ", attempt " + attempt + ", data offset " + offset), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            if (this.runningExecutions.get().containsKey(exFlow.getExecutionId())) {
                Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
                this.apiGateway.callWithReferenceByUser(pair.getFirst(), "cancel", userId, new Pair[0]);
            } else if (this.queuedFlows.hasExecution(exFlow.getExecutionId())) {
                this.queuedFlows.dequeue(exFlow.getExecutionId());
                this.executionFinalizer.finalizeFlow(exFlow, "Cancelled before dispatching to executor", null);
            } else {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.apiGateway.callWithReferenceByUser(pair.getFirst(), "resume", userId, new Pair[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseFlow(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            this.apiGateway.callWithReferenceByUser(pair.getFirst(), "pause", userId, new Pair[0]);
        }
    }

    @Override
    public void retryFailures(ExecutableFlow exFlow, String userId) throws ExecutorManagerException {
        this.modifyExecutingJobs(exFlow, "retryFailures", userId, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> modifyExecutingJobs(ExecutableFlow exFlow, String command, String userId, String ... jobIds) throws ExecutorManagerException {
        ExecutableFlow executableFlow = exFlow;
        synchronized (executableFlow) {
            Map<String, Object> response;
            Pair<ExecutionReference, ExecutableFlow> pair = this.runningExecutions.get().get(exFlow.getExecutionId());
            if (pair == null) {
                throw new ExecutorManagerException("Execution " + exFlow.getExecutionId() + " of flow " + exFlow.getFlowId() + " isn't running.");
            }
            if (jobIds != null && jobIds.length > 0) {
                for (String jobId : jobIds) {
                    ExecutableNode node;
                    if (jobId.isEmpty() || (node = exFlow.getExecutableNode(jobId)) != null) continue;
                    throw new ExecutorManagerException("Job " + jobId + " doesn't exist in execution " + exFlow.getExecutionId() + ".");
                }
                String ids = StringUtils.join((Object[])jobIds, (char)',');
                response = this.apiGateway.callWithReferenceByUser(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command), new Pair<String, String>("jobIds", ids));
            } else {
                response = this.apiGateway.callWithReferenceByUser(pair.getFirst(), "modifyExecution", userId, new Pair<String, String>("modifyType", command));
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String submitExecutableFlow(ExecutableFlow exflow, String userId) throws ExecutorManagerException {
        String exFlowKey = exflow.getProjectName() + "." + exflow.getId() + ".submitFlow";
        String string = exFlowKey.intern();
        synchronized (string) {
            String flowId = exflow.getFlowId();
            logger.info((Object)("Submitting execution flow " + flowId + " by " + userId));
            String message = "";
            if (this.queuedFlows.isFull()) {
                message = String.format("Failed to submit %s for project %s. Azkaban has overrun its webserver queue capacity", flowId, exflow.getProjectName());
                logger.error((Object)message);
                this.commonMetrics.markSubmitFlowFail();
            } else {
                int projectId = exflow.getProjectId();
                exflow.setSubmitUser(userId);
                exflow.setStatus(Status.PREPARING);
                exflow.setSubmitTime(System.currentTimeMillis());
                List<Integer> running = this.getRunningFlows(projectId, flowId);
                ExecutionOptions options = exflow.getExecutionOptions();
                if (options == null) {
                    options = new ExecutionOptions();
                }
                if (options.getDisabledJobs() != null) {
                    FlowUtils.applyDisabledJobs(options.getDisabledJobs(), exflow);
                }
                if (!running.isEmpty()) {
                    if (running.size() > this.maxConcurrentRunsOneFlow) {
                        this.commonMetrics.markSubmitFlowSkip();
                        throw new ExecutorManagerException("Flow " + flowId + " has more than " + this.maxConcurrentRunsOneFlow + " concurrent runs. Skipping", ExecutorManagerException.Reason.SkippedExecution);
                    }
                    if (options.getConcurrentOption().equals("pipeline")) {
                        Collections.sort(running);
                        Integer runningExecId = running.get(running.size() - 1);
                        options.setPipelineExecutionId(runningExecId);
                        message = "Flow " + flowId + " is already running with exec id " + runningExecId + ". Pipelining level " + options.getPipelineLevel() + ". \n";
                    } else {
                        if (options.getConcurrentOption().equals("skip")) {
                            this.commonMetrics.markSubmitFlowSkip();
                            throw new ExecutorManagerException("Flow " + flowId + " is already running. Skipping execution.", ExecutorManagerException.Reason.SkippedExecution);
                        }
                        message = "Flow " + flowId + " is already running with exec id " + StringUtils.join(running, (String)",") + ". Will execute concurrently. \n";
                    }
                }
                boolean memoryCheck = !ProjectWhitelist.isProjectWhitelisted(exflow.getProjectId(), ProjectWhitelist.WhitelistType.MemoryCheck);
                options.setMemoryCheck(memoryCheck);
                this.executorLoader.uploadExecutableFlow(exflow);
                ExecutionReference reference = new ExecutionReference(exflow.getExecutionId());
                this.executorLoader.addActiveExecutableReference(reference);
                this.queuedFlows.enqueue(exflow, reference);
                message = message + "Execution queued successfully with exec id " + exflow.getExecutionId();
                this.commonMetrics.markSubmitFlowSuccess();
            }
            return message;
        }
    }

    private void cleanOldExecutionLogs(long millis) {
        long beforeDeleteLogsTimestamp = System.currentTimeMillis();
        try {
            int count = this.executorLoader.removeExecutionLogsByTime(millis);
            logger.info((Object)("Cleaned up " + count + " log entries."));
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"log clean up failed. ", (Throwable)e);
        }
        logger.info((Object)("log clean up time: " + (System.currentTimeMillis() - beforeDeleteLogsTimestamp) / 1000L + " seconds."));
    }

    @Override
    public Map<String, Object> callExecutorStats(int executorId, String action, Pair<String, String> ... params) throws IOException, ExecutorManagerException {
        Executor executor = this.fetchExecutor(executorId);
        ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
        if (params != null) {
            paramList.addAll(Arrays.asList(params));
        }
        paramList.add(new Pair<String, String>("action", action));
        return this.apiGateway.callForJsonObjectMap(executor.getHost(), executor.getPort(), "/stats", paramList);
    }

    @Override
    public Map<String, Object> callExecutorJMX(String hostPort, String action, String mBean) throws IOException {
        ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
        paramList.add(new Pair<String, String>(action, ""));
        if (mBean != null) {
            paramList.add(new Pair<String, String>("mBean", mBean));
        }
        String[] hostPortSplit = hostPort.split(":");
        return this.apiGateway.callForJsonObjectMap(hostPortSplit[0], Integer.valueOf(hostPortSplit[1]), "/jmx", paramList);
    }

    @Override
    public void shutdown() {
        this.queueProcessor.shutdown();
        this.updaterThread.shutdown();
    }

    @Override
    public int getExecutableFlows(int projectId, String flowId, int from, int length, List<ExecutableFlow> outputList) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executorLoader.fetchFlowHistory(projectId, flowId, from, length);
        outputList.addAll(flows);
        return this.executorLoader.fetchNumExecutableFlows(projectId, flowId);
    }

    @Override
    public List<ExecutableFlow> getExecutableFlows(int projectId, String flowId, int from, int length, Status status) throws ExecutorManagerException {
        return this.executorLoader.fetchFlowHistory(projectId, flowId, from, length, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(ExecutionReference reference, ExecutableFlow exflow, Executor choosenExecutor) throws ExecutorManagerException {
        exflow.setUpdateTime(System.currentTimeMillis());
        this.executorLoader.assignExecutor(choosenExecutor.getId(), exflow.getExecutionId());
        try {
            this.apiGateway.callWithExecutable(exflow, choosenExecutor, "execute");
        }
        catch (ExecutorManagerException ex) {
            logger.error((Object)("Rolling back executor assignment for execution id:" + exflow.getExecutionId()), (Throwable)ex);
            this.executorLoader.unassignExecutor(exflow.getExecutionId());
            throw new ExecutorManagerException(ex);
        }
        reference.setExecutor(choosenExecutor);
        this.runningExecutions.get().put(exflow.getExecutionId(), new Pair<ExecutionReference, ExecutableFlow>(reference, exflow));
        Object object = this.runningExecutions.get();
        synchronized (object) {
            this.runningExecutions.get().notifyAll();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        logger.info((Object)String.format("Successfully dispatched exec %d with error count %d", exflow.getExecutionId(), reference.getNumErrors()));
    }

    @VisibleForTesting
    void setSleepAfterDispatchFailure(Duration sleepAfterDispatchFailure) {
        this.sleepAfterDispatchFailure = sleepAfterDispatchFailure;
    }

    private class QueueProcessorThread
    extends Thread {
        private static final long QUEUE_PROCESSOR_WAIT_IN_MS = 1000L;
        private final int maxDispatchingErrors;
        private final long activeExecutorRefreshWindowInMillisec;
        private final int activeExecutorRefreshWindowInFlows;
        private final Duration sleepAfterDispatchFailure;
        private volatile boolean shutdown = false;
        private volatile boolean isActive = true;

        public QueueProcessorThread(boolean isActive, long activeExecutorRefreshWindowInTime, int activeExecutorRefreshWindowInFlows, int maxDispatchingErrors, Duration sleepAfterDispatchFailure) {
            this.setActive(isActive);
            this.maxDispatchingErrors = maxDispatchingErrors;
            this.activeExecutorRefreshWindowInFlows = activeExecutorRefreshWindowInFlows;
            this.activeExecutorRefreshWindowInMillisec = activeExecutorRefreshWindowInTime;
            this.sleepAfterDispatchFailure = sleepAfterDispatchFailure;
            this.setName("AzkabanWebServer-QueueProcessor-Thread");
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
            logger.info((Object)("QueueProcessorThread active turned " + this.isActive));
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                QueueProcessorThread queueProcessorThread = this;
                synchronized (queueProcessorThread) {
                    try {
                        if (this.isActive) {
                            this.processQueuedFlows(this.activeExecutorRefreshWindowInMillisec, this.activeExecutorRefreshWindowInFlows);
                        }
                        this.wait(1000L);
                    }
                    catch (Exception e) {
                        logger.error((Object)"QueueProcessorThread Interrupted. Probably to shut down.", (Throwable)e);
                    }
                }
            }
        }

        private void processQueuedFlows(long activeExecutorsRefreshWindow, int maxContinuousFlowProcessed) throws InterruptedException, ExecutorManagerException {
            long lastExecutorRefreshTime = 0L;
            int currentContinuousFlowProcessed = 0;
            while (this.isActive() && (ExecutorManager.this.runningCandidate = ExecutorManager.this.queuedFlows.fetchHead()) != null) {
                ExecutionReference reference = (ExecutionReference)ExecutorManager.this.runningCandidate.getFirst();
                ExecutableFlow exflow = (ExecutableFlow)ExecutorManager.this.runningCandidate.getSecond();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastExecutorRefreshTime > activeExecutorsRefreshWindow || currentContinuousFlowProcessed >= maxContinuousFlowProcessed) {
                    ExecutorManager.this.refreshExecutors();
                    lastExecutorRefreshTime = currentTime;
                    currentContinuousFlowProcessed = 0;
                }
                if (exflow.getUpdateTime() > lastExecutorRefreshTime) {
                    ExecutorManager.this.queuedFlows.enqueue(exflow, reference);
                    ExecutorManager.this.runningCandidate = null;
                    long sleepInterval = activeExecutorsRefreshWindow - (currentTime - lastExecutorRefreshTime);
                    Thread.sleep(sleepInterval);
                } else {
                    exflow.setUpdateTime(currentTime);
                    this.selectExecutorAndDispatchFlow(reference, exflow);
                    ExecutorManager.this.runningCandidate = null;
                }
                if (ExecutorManager.this.queuedFlows.getFlow(exflow.getExecutionId()) != null) continue;
                ++currentContinuousFlowProcessed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectExecutorAndDispatchFlow(ExecutionReference reference, ExecutableFlow exflow) throws ExecutorManagerException {
            HashSet<Executor> remainingExecutors = new HashSet<Executor>(ExecutorManager.this.activeExecutors.getAll());
            ExecutableFlow executableFlow = exflow;
            synchronized (executableFlow) {
                while (true) {
                    Executor selectedExecutor;
                    if ((selectedExecutor = this.selectExecutor(exflow, remainingExecutors)) == null) {
                        ExecutorManager.this.commonMetrics.markDispatchFail();
                        this.handleNoExecutorSelectedCase(reference, exflow);
                        return;
                    }
                    try {
                        ExecutorManager.this.dispatch(reference, exflow, selectedExecutor);
                        ExecutorManager.this.commonMetrics.markDispatchSuccess();
                        return;
                    }
                    catch (ExecutorManagerException e) {
                        ExecutorManagerException lastError = e;
                        this.logFailedDispatchAttempt(reference, exflow, selectedExecutor, e);
                        ExecutorManager.this.commonMetrics.markDispatchFail();
                        reference.setNumErrors(reference.getNumErrors() + 1);
                        this.updateRemainingExecutorsAndSleep(remainingExecutors, selectedExecutor);
                        if (reference.getNumErrors() < this.maxDispatchingErrors) continue;
                        String message = "Failed to dispatch queued execution " + exflow.getId() + " because reached " + "azkaban.maxDispatchingErrors" + " (tried " + reference.getNumErrors() + " executors)";
                        logger.error((Object)message);
                        ExecutorManager.this.executionFinalizer.finalizeFlow(exflow, message, lastError);
                    }
                    break;
                }
            }
        }

        private void updateRemainingExecutorsAndSleep(Set<Executor> remainingExecutors, Executor selectedExecutor) {
            remainingExecutors.remove(selectedExecutor);
            if (remainingExecutors.isEmpty()) {
                remainingExecutors.addAll(ExecutorManager.this.activeExecutors.getAll());
                this.sleepAfterDispatchFailure();
            }
        }

        private void sleepAfterDispatchFailure() {
            try {
                Thread.sleep(this.sleepAfterDispatchFailure.toMillis());
            }
            catch (InterruptedException e1) {
                logger.warn((Object)"Sleep after dispatch failure was interrupted - ignoring");
            }
        }

        private void logFailedDispatchAttempt(ExecutionReference reference, ExecutableFlow exflow, Executor selectedExecutor, ExecutorManagerException e) {
            logger.warn((Object)String.format("Executor %s responded with exception for exec: %d", selectedExecutor, exflow.getExecutionId()), (Throwable)e);
            logger.info((Object)String.format("Failed dispatch attempt for exec %d with error count %d", exflow.getExecutionId(), reference.getNumErrors()));
        }

        private Executor getUserSpecifiedExecutor(ExecutionOptions options, int executionId) {
            Executor executor = null;
            if (options != null && options.getFlowParameters() != null && options.getFlowParameters().containsKey("useExecutor")) {
                try {
                    int executorId = Integer.valueOf(options.getFlowParameters().get("useExecutor"));
                    executor = ExecutorManager.this.fetchExecutor(executorId);
                    if (executor == null) {
                        logger.warn((Object)String.format("User specified executor id: %d for execution id: %d is not active, Looking up db.", executorId, executionId));
                        executor = ExecutorManager.this.executorLoader.fetchExecutor(executorId);
                        if (executor == null) {
                            logger.warn((Object)String.format("User specified executor id: %d for execution id: %d is missing from db. Defaulting to availableExecutors", executorId, executionId));
                        }
                    }
                }
                catch (ExecutorManagerException ex) {
                    logger.error((Object)("Failed to fetch user specified executor for exec_id = " + executionId), (Throwable)ex);
                }
            }
            return executor;
        }

        private Executor selectExecutor(ExecutableFlow exflow, Set<Executor> availableExecutors) {
            Executor choosenExecutor = this.getUserSpecifiedExecutor(exflow.getExecutionOptions(), exflow.getExecutionId());
            if (choosenExecutor == null) {
                logger.info((Object)("Using dispatcher for execution id :" + exflow.getExecutionId()));
                ExecutorSelector selector = new ExecutorSelector(ExecutorManager.this.filterList, ExecutorManager.this.comparatorWeightsMap);
                choosenExecutor = selector.getBest(availableExecutors, exflow);
            }
            return choosenExecutor;
        }

        private void handleNoExecutorSelectedCase(ExecutionReference reference, ExecutableFlow exflow) throws ExecutorManagerException {
            logger.info((Object)String.format("Reached handleNoExecutorSelectedCase stage for exec %d with error count %d", exflow.getExecutionId(), reference.getNumErrors()));
            ExecutorManager.this.queuedFlows.enqueue(exflow, reference);
        }
    }

    private class CleanerThread
    extends Thread {
        private static final long CLEANER_THREAD_WAIT_INTERVAL_MS = 3600000L;
        private final long executionLogsRetentionMs;
        private boolean shutdown = false;
        private long lastLogCleanTime = -1L;

        public CleanerThread(long executionLogsRetentionMs) {
            this.executionLogsRetentionMs = executionLogsRetentionMs;
            this.setName("AzkabanWebServer-Cleaner-Thread");
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                CleanerThread cleanerThread = this;
                synchronized (cleanerThread) {
                    try {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - 3600000L > this.lastLogCleanTime) {
                            this.cleanExecutionLogs();
                            this.lastLogCleanTime = currentTime;
                        }
                        this.wait(3600000L);
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Interrupted. Probably to shut down.");
                    }
                }
            }
        }

        private void cleanExecutionLogs() {
            logger.info((Object)"Cleaning old logs from execution_logs");
            long cutoff = System.currentTimeMillis() - this.executionLogsRetentionMs;
            logger.info((Object)("Cleaning old log files before " + new DateTime(cutoff).toString()));
            ExecutorManager.this.cleanOldExecutionLogs(System.currentTimeMillis() - this.executionLogsRetentionMs);
        }
    }
}

