/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorDao;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

@Singleton
public class ExecutionJobDao {
    private static final Logger logger = Logger.getLogger(ExecutorDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    ExecutionJobDao(DatabaseOperator databaseOperator) {
        this.dbOperator = databaseOperator;
    }

    public void uploadExecutableNode(ExecutableNode node, Props inputProps) throws ExecutorManagerException {
        String INSERT_EXECUTION_NODE = "INSERT INTO execution_jobs (exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, input_params, attempt) VALUES (?,?,?,?,?,?,?,?,?,?)";
        byte[] inputParam = null;
        if (inputProps != null) {
            try {
                String jsonString = JSONUtils.toJSON((Object)PropsUtils.toHierarchicalMap((Props)inputProps));
                inputParam = GZIPUtils.gzipString(jsonString, "UTF-8");
            }
            catch (IOException e) {
                throw new ExecutorManagerException("Error encoding input params");
            }
        }
        ExecutableFlow flow = node.getExecutableFlow();
        String flowId = node.getParentFlow().getFlowPath();
        logger.info((Object)("Uploading flowId " + flowId));
        try {
            this.dbOperator.update("INSERT INTO execution_jobs (exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, input_params, attempt) VALUES (?,?,?,?,?,?,?,?,?,?)", new Object[]{flow.getExecutionId(), flow.getProjectId(), flow.getVersion(), flowId, node.getId(), node.getStartTime(), node.getEndTime(), node.getStatus().getNumVal(), inputParam, node.getAttempt()});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error writing job " + node.getId(), e);
        }
    }

    public void updateExecutableNode(ExecutableNode node) throws ExecutorManagerException {
        String UPSERT_EXECUTION_NODE = "UPDATE execution_jobs SET start_time=?, end_time=?, status=?, output_params=? WHERE exec_id=? AND flow_id=? AND job_id=? AND attempt=?";
        byte[] outputParam = null;
        Props outputProps = node.getOutputProps();
        if (outputProps != null) {
            try {
                String jsonString = JSONUtils.toJSON((Object)PropsUtils.toHierarchicalMap((Props)outputProps));
                outputParam = GZIPUtils.gzipString(jsonString, "UTF-8");
            }
            catch (IOException e) {
                throw new ExecutorManagerException("Error encoding input params");
            }
        }
        try {
            this.dbOperator.update("UPDATE execution_jobs SET start_time=?, end_time=?, status=?, output_params=? WHERE exec_id=? AND flow_id=? AND job_id=? AND attempt=?", new Object[]{node.getStartTime(), node.getEndTime(), node.getStatus().getNumVal(), outputParam, node.getExecutableFlow().getExecutionId(), node.getParentFlow().getFlowPath(), node.getId(), node.getAttempt()});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error updating job " + node.getId(), e);
        }
    }

    public List<ExecutableJobInfo> fetchJobInfoAttempts(int execId, String jobId) throws ExecutorManagerException {
        try {
            List info = (List)this.dbOperator.query("SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE exec_id=? AND job_id=?", (ResultSetHandler)new FetchExecutableJobHandler(), new Object[]{execId, jobId});
            if (info == null || info.isEmpty()) {
                return null;
            }
            return info;
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job info " + jobId, e);
        }
    }

    public ExecutableJobInfo fetchJobInfo(int execId, String jobId, int attempts) throws ExecutorManagerException {
        try {
            List info = (List)this.dbOperator.query("SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE exec_id=? AND job_id=? AND attempt=?", (ResultSetHandler)new FetchExecutableJobHandler(), new Object[]{execId, jobId, attempts});
            if (info == null || info.isEmpty()) {
                return null;
            }
            return (ExecutableJobInfo)info.get(0);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job info " + jobId, e);
        }
    }

    public Props fetchExecutionJobInputProps(int execId, String jobId) throws ExecutorManagerException {
        try {
            Pair props = (Pair)this.dbOperator.query("SELECT input_params FROM execution_jobs WHERE exec_id=? AND job_id=?", (ResultSetHandler)new FetchExecutableJobPropsHandler(), new Object[]{execId, jobId});
            return (Props)props.getFirst();
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job params " + execId + " " + jobId, e);
        }
    }

    public Props fetchExecutionJobOutputProps(int execId, String jobId) throws ExecutorManagerException {
        try {
            Pair props = (Pair)this.dbOperator.query("SELECT output_params FROM execution_jobs WHERE exec_id=? AND job_id=?", (ResultSetHandler)new FetchExecutableJobPropsHandler(), new Object[]{execId, jobId});
            return (Props)props.getFirst();
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job params " + execId + " " + jobId, e);
        }
    }

    public Pair<Props, Props> fetchExecutionJobProps(int execId, String jobId) throws ExecutorManagerException {
        try {
            return (Pair)this.dbOperator.query("SELECT input_params, output_params FROM execution_jobs WHERE exec_id=? AND job_id=?", (ResultSetHandler)new FetchExecutableJobPropsHandler(), new Object[]{execId, jobId});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job params " + execId + " " + jobId, e);
        }
    }

    public List<ExecutableJobInfo> fetchJobHistory(int projectId, String jobId, int skip, int size) throws ExecutorManagerException {
        try {
            List info = (List)this.dbOperator.query("SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE project_id=? AND job_id=? ORDER BY exec_id DESC LIMIT ?, ? ", (ResultSetHandler)new FetchExecutableJobHandler(), new Object[]{projectId, jobId, skip, size});
            if (info == null || info.isEmpty()) {
                return null;
            }
            return info;
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error querying job info " + jobId, e);
        }
    }

    public List<Object> fetchAttachments(int execId, String jobId, int attempt) throws ExecutorManagerException {
        try {
            String attachments = (String)this.dbOperator.query("SELECT attachments FROM execution_jobs WHERE exec_id=? AND job_id=?", (ResultSetHandler)new FetchExecutableJobAttachmentsHandler(), new Object[]{execId, jobId});
            if (attachments == null) {
                return null;
            }
            return (List)JSONUtils.parseJSONFromString((String)attachments);
        }
        catch (IOException e) {
            throw new ExecutorManagerException("Error converting job attachments to JSON " + jobId, e);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error query job attachments " + jobId, e);
        }
    }

    public void uploadAttachmentFile(ExecutableNode node, File file) throws ExecutorManagerException {
        String UPDATE_EXECUTION_NODE_ATTACHMENTS = "UPDATE execution_jobs SET attachments=? WHERE exec_id=? AND flow_id=? AND job_id=? AND attempt=?";
        try {
            String jsonString = FileUtils.readFileToString((File)file);
            byte[] attachments = GZIPUtils.gzipString(jsonString, "UTF-8");
            this.dbOperator.update("UPDATE execution_jobs SET attachments=? WHERE exec_id=? AND flow_id=? AND job_id=? AND attempt=?", new Object[]{attachments, node.getExecutableFlow().getExecutionId(), node.getParentFlow().getNestedId(), node.getId(), node.getAttempt()});
        }
        catch (IOException | SQLException e) {
            throw new ExecutorManagerException("Error uploading attachments.", e);
        }
    }

    private static class FetchExecutableJobAttachmentsHandler
    implements ResultSetHandler<String> {
        private static final String FETCH_ATTACHMENTS_EXECUTABLE_NODE = "SELECT attachments FROM execution_jobs WHERE exec_id=? AND job_id=?";

        private FetchExecutableJobAttachmentsHandler() {
        }

        public String handle(ResultSet rs) throws SQLException {
            String attachmentsJson = null;
            if (rs.next()) {
                try {
                    byte[] attachments = rs.getBytes(1);
                    if (attachments != null) {
                        attachmentsJson = GZIPUtils.unGzipString(attachments, "UTF-8");
                    }
                }
                catch (IOException e) {
                    throw new SQLException("Error decoding job attachments", e);
                }
            }
            return attachmentsJson;
        }
    }

    private static class FetchExecutableJobPropsHandler
    implements ResultSetHandler<Pair<Props, Props>> {
        private static final String FETCH_OUTPUT_PARAM_EXECUTABLE_NODE = "SELECT output_params FROM execution_jobs WHERE exec_id=? AND job_id=?";
        private static final String FETCH_INPUT_PARAM_EXECUTABLE_NODE = "SELECT input_params FROM execution_jobs WHERE exec_id=? AND job_id=?";
        private static final String FETCH_INPUT_OUTPUT_PARAM_EXECUTABLE_NODE = "SELECT input_params, output_params FROM execution_jobs WHERE exec_id=? AND job_id=?";

        private FetchExecutableJobPropsHandler() {
        }

        public Pair<Props, Props> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return new Pair<Object, Object>(null, null);
            }
            if (rs.getMetaData().getColumnCount() > 1) {
                byte[] input = rs.getBytes(1);
                byte[] output = rs.getBytes(2);
                Props inputProps = null;
                Props outputProps = null;
                try {
                    if (input != null) {
                        String jsonInputString = GZIPUtils.unGzipString(input, "UTF-8");
                        inputProps = PropsUtils.fromHierarchicalMap((Map)((Map)JSONUtils.parseJSONFromString((String)jsonInputString)));
                    }
                    if (output != null) {
                        String jsonOutputString = GZIPUtils.unGzipString(output, "UTF-8");
                        outputProps = PropsUtils.fromHierarchicalMap((Map)((Map)JSONUtils.parseJSONFromString((String)jsonOutputString)));
                    }
                }
                catch (IOException e) {
                    throw new SQLException("Error decoding param data", e);
                }
                return new Pair<Object, Object>(inputProps, outputProps);
            }
            byte[] params = rs.getBytes(1);
            Props props = null;
            try {
                if (params != null) {
                    String jsonProps = GZIPUtils.unGzipString(params, "UTF-8");
                    props = PropsUtils.fromHierarchicalMap((Map)((Map)JSONUtils.parseJSONFromString((String)jsonProps)));
                }
            }
            catch (IOException e) {
                throw new SQLException("Error decoding param data", e);
            }
            return new Pair<Object, Object>(props, null);
        }
    }

    private static class FetchExecutableJobHandler
    implements ResultSetHandler<List<ExecutableJobInfo>> {
        private static final String FETCH_EXECUTABLE_NODE = "SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE exec_id=? AND job_id=? AND attempt=?";
        private static final String FETCH_EXECUTABLE_NODE_ATTEMPTS = "SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE exec_id=? AND job_id=?";
        private static final String FETCH_PROJECT_EXECUTABLE_NODE = "SELECT exec_id, project_id, version, flow_id, job_id, start_time, end_time, status, attempt FROM execution_jobs WHERE project_id=? AND job_id=? ORDER BY exec_id DESC LIMIT ?, ? ";

        private FetchExecutableJobHandler() {
        }

        public List<ExecutableJobInfo> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<ExecutableJobInfo> execNodes = new ArrayList<ExecutableJobInfo>();
            do {
                int execId = rs.getInt(1);
                int projectId = rs.getInt(2);
                int version = rs.getInt(3);
                String flowId = rs.getString(4);
                String jobId = rs.getString(5);
                long startTime = rs.getLong(6);
                long endTime = rs.getLong(7);
                Status status = Status.fromInteger(rs.getInt(8));
                int attempt = rs.getInt(9);
                ExecutableJobInfo info = new ExecutableJobInfo(execId, projectId, version, flowId, jobId, startTime, endTime, status, attempt);
                execNodes.add(info);
            } while (rs.next());
            return execNodes;
        }
    }
}

