/*
 * Decompiled with CFR 0.152.
 */
package azkaban.event;

import azkaban.event.EventData;
import azkaban.spi.EventType;
import com.google.common.base.Preconditions;

public class Event {
    private final Object runner;
    private final EventType type;
    private final EventData eventData;
    private final long time;

    private Event(Object runner, EventType type, EventData eventData) {
        this.runner = runner;
        this.type = type;
        this.eventData = eventData;
        this.time = System.currentTimeMillis();
    }

    public static Event create(Object runner, EventType type, EventData eventData) throws NullPointerException {
        Preconditions.checkNotNull((Object)eventData, (Object)"EventData was null");
        return new Event(runner, type, eventData);
    }

    public Object getRunner() {
        return this.runner;
    }

    public EventType getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public EventData getData() {
        return this.eventData;
    }
}

