/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.aliyunemr;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtil {
    private static final Logger log = LoggerFactory.getLogger(CronUtil.class);

    public static String cronToDwCron(String cron) {
        String[] weeks;
        if (StringUtils.isBlank((CharSequence)cron)) {
            return cron;
        }
        CharSequence[] parts = StringUtils.split((String)cron, (String)" \t");
        if (parts == null || parts.length != 6) {
            log.warn("invalid quartz cron part count: {}", (Object)cron);
            return cron;
        }
        String week = parts[5];
        if (StringUtils.isNumeric((CharSequence)week)) {
            parts[5] = String.valueOf(CronUtil.rotateWeek(Integer.parseInt(week)));
        } else if (StringUtils.contains((CharSequence)week, (CharSequence)",")) {
            String[] weeks2 = StringUtils.split((String)week, (String)",");
            parts[5] = Stream.of(weeks2).map(Integer::valueOf).map(CronUtil::rotateWeek).map(String::valueOf).collect(Collectors.joining(","));
        } else if (StringUtils.contains((CharSequence)week, (CharSequence)"-") && (weeks = StringUtils.split((String)week, (String)"-")).length == 2) {
            parts[5] = CronUtil.rotateWeek(Integer.parseInt(weeks[0])) + "-" + CronUtil.rotateWeek(Integer.parseInt(weeks[1]));
        }
        return String.join((CharSequence)" ", parts);
    }

    private static int rotateWeek(int week) {
        switch (week) {
            case 1: {
                return 7;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return week;
    }
}

