/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.temp;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinschedulerApiV3Service
extends com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinschedulerApiV3Service {
    private static final Logger log = LoggerFactory.getLogger(DolphinschedulerApiV3Service.class);
    private String endpoint;
    private String token;

    public DolphinschedulerApiV3Service(String endpoint, String token) {
        super(endpoint, token);
        this.endpoint = endpoint;
        this.token = token;
    }

    public File downloadResource(DownloadResourceRequest request) throws Exception {
        String url = Config.get().isVersion32() ? String.format("resources/download?fullName=%s", URLEncoder.encode(request.getFullName(), "UTF-8")) : String.format("resources/%d/download", request.getId());
        HttpClientUtil client = new HttpClientUtil();
        log.info("download resource url: {}", (Object)url);
        HttpGet httpGet = this.newHttpGet(url);
        HttpResponse resp = client.executeAndGetHttpResponse((HttpRequestBase)httpGet);
        if (200 != resp.getStatusLine().getStatusCode()) {
            log.error("response error {}, fullname: {}, url: {}", new Object[]{resp.getStatusLine(), request.getFullName(), url});
            throw new RuntimeException("download file " + url + " error with status " + resp.getStatusLine());
        }
        log.info("download resp: {}", (Object)JSONObject.toJSONString((Object)resp, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        InputStream inputStream = resp.getEntity().getContent();
        String fileName = Stream.of(resp.getAllHeaders()).filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Content-Disposition")).findFirst().map(this::getSuggestedFileName).orElse(null);
        log.info("download file name: {}", (Object)fileName);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String content = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8);
            Response response = (Response)GsonUtils.fromJsonString((String)content, (Type)new TypeToken<Response<Object>>(){}.getType());
            log.warn("download resource url: {} failed: {}", (Object)url, (Object)Optional.ofNullable(response).map(Response::getMsg).orElse(content));
            return null;
        }
        File tmpFile = new File(request.getDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return tmpFile;
    }

    private HttpGet newHttpGet(String url) throws URISyntaxException {
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String finalUrl = MessageFormat.format("{0}/dolphinscheduler/{1}", this.endpoint, url);
        httpGet.setURI(new URI(finalUrl));
        return httpGet;
    }

    private String getSuggestedFileName(Header contentDispositionHeader) {
        String value = contentDispositionHeader.getValue();
        log.info("contentDispositionHeader: {}", (Object)value);
        return Arrays.stream(StringUtils.split((String)value, (String)";")).map(StringUtils::trim).filter(token -> StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"filename=")).findFirst().map(fileNamePart -> StringUtils.replace((String)fileNamePart, (String)"filename=", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"^\"", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"\"$", (String)"")).map(x -> {
            try {
                return URLDecoder.decode(x, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("urlDecoder decode error: {}", (Object)e.getMessage());
                return null;
            }
        }).orElse(null);
    }

    public List<JsonElement> queryResourceListByPage(QueryResourceListRequest request, int pageNum, int pageSize) throws Exception {
        String url;
        HttpClientUtil client = new HttpClientUtil();
        if (Config.get().isVersion32()) {
            String fullName = request.getFullName() == null ? "" : URLEncoder.encode(request.getFullName(), "UTF-8");
            url = String.format("resources?type=%s&pageNo=%s&pageSize=%s&fullName=%s&tenantCode=&searchVal=&id=%s", request.getType(), pageNum, pageSize, fullName, request.getDirId());
        } else {
            url = String.format("resources?type=%s&pageNo=%s&pageSize=%s&id=%s", request.getType(), pageNum, pageSize, request.getDirId());
        }
        HttpGet httpGet = this.newHttpGet(url);
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        log.info("response {}", (Object)responseStr);
        Response response = (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<JsonObject>>(){}.getType());
        if (response.getCode() > 0) {
            log.error("response error {}", (Object)responseStr);
            return null;
        }
        JsonObject data = (JsonObject)response.getData();
        if (!data.has("totalList")) {
            log.error("response {}", (Object)responseStr);
            return null;
        }
        return data.get("totalList").getAsJsonArray().asList();
    }
}

