/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.temp;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.BatchExportProcessDefinitionByIdsRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DownloadResourceRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.QueryResourceListRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response;
import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerApiService
extends com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApiService {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerApiService.class);
    private String endpoint;
    private String token;
    private String version;
    private Boolean downloadResource;

    public void setVersion(String version) {
        this.version = version;
    }

    public DolphinSchedulerApiService(String endpoint, String token) {
        super(endpoint, token);
        this.endpoint = endpoint;
        this.token = token;
    }

    public DolphinSchedulerApiService(String endpoint, String token, String version, Boolean dowloadResource) {
        super(endpoint, token);
        this.endpoint = endpoint;
        this.token = token;
        this.version = version;
        this.downloadResource = dowloadResource;
    }

    public Response<List<JsonObject>> queryAllProjectList(DolphinSchedulerRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/projects/query-project-list", this.endpoint);
        if (this.version != null && this.isHigherVersion(this.version, "1.2.0") <= 0) {
            url = String.format("%s/dolphinscheduler/projects/queryAllProjectList", this.endpoint);
        }
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    public File downloadResource(DownloadResourceRequest request) throws Exception {
        if (!this.downloadResource.booleanValue()) {
            return null;
        }
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/resources/download?id=%s", this.endpoint, request.getId());
        httpGet.setURI(new URI(url));
        HttpResponse resp = client.executeAndGetHttpResponse((HttpRequestBase)httpGet);
        InputStream inputStream = resp.getEntity().getContent();
        String fileName = Stream.of(resp.getAllHeaders()).filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Content-Disposition")).findFirst().map(this::getSuggestedFileName).orElse(null);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String content = EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.warn("download resource id: {} failed: no filename, res: {}, rqt header: {}", new Object[]{request.getId(), content, Arrays.stream(resp.getAllHeaders()).toList().toString()});
            return null;
        }
        File tmpFile = new File(request.getDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return tmpFile;
    }

    private String getSuggestedFileName(Header contentDispositionHeader) {
        String value = contentDispositionHeader.getValue();
        return Arrays.stream(StringUtils.split((String)value, (String)";")).map(StringUtils::trim).filter(token -> StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)"filename=")).findFirst().map(fileNamePart -> StringUtils.replace((String)fileNamePart, (String)"filename=", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"^\"", (String)"")).map(fileName -> RegExUtils.replaceAll((String)fileName, (String)"\"$", (String)"")).orElse(null);
    }

    public Response<List<JsonObject>> queryResourceList(QueryResourceListRequest request) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/resources/list?type=%s", this.endpoint, request.getType());
        httpGet.setURI(new URI(url));
        String responseStr = client.executeAndGet((HttpRequestBase)httpGet);
        responseStr = responseStr.replace("\"dirctory\"", "\"directory\"");
        return (Response)GsonUtils.fromJsonString((String)responseStr, (Type)new TypeToken<Response<List<JsonObject>>>(){}.getType());
    }

    public int isHigherVersion(String version, String basicVersion) {
        ArrayList<Integer> basicVersionNumber = new ArrayList<Integer>();
        for (String num : basicVersion.split("\\.")) {
            basicVersionNumber.add(Integer.parseInt(num));
        }
        ArrayList<Integer> versionNumber = new ArrayList<Integer>();
        for (String num : version.split("\\.")) {
            versionNumber.add(Integer.parseInt(num));
        }
        if (versionNumber.size() > basicVersionNumber.size()) {
            for (int i = basicVersionNumber.size(); i < versionNumber.size(); ++i) {
                basicVersionNumber.add(0);
            }
        } else if (versionNumber.size() < basicVersionNumber.size()) {
            for (int i = versionNumber.size(); i < basicVersionNumber.size(); ++i) {
                versionNumber.add(0);
            }
        }
        for (int index = 0; index < basicVersionNumber.size(); ++index) {
            if ((Integer)versionNumber.get(index) > (Integer)basicVersionNumber.get(index)) {
                return 1;
            }
            if ((Integer)versionNumber.get(index) >= (Integer)basicVersionNumber.get(index)) continue;
            return -1;
        }
        return 0;
    }

    public String batchExportProcessDefinitionByIds(BatchExportProcessDefinitionByIdsRequest request) throws Exception {
        if (this.version != null && this.isHigherVersion(this.version, "1.2.0") <= 0) {
            String responses = "[";
            for (String id : request.getIds()) {
                String response = this.batchExportProcessDefinitionById(request, id);
                if (responses.length() > 2) {
                    responses = responses.concat(",");
                }
                responses = responses.concat(response);
            }
            responses = responses.concat("]");
            return responses;
        }
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/projects/%s/process/export?processDefinitionIds=%s", this.endpoint, request.getProjectName(), Joiner.on((String)",").join((Iterable)ListUtils.emptyIfNull((List)request.getIds()).stream().distinct().collect(Collectors.toList())));
        httpGet.setURI(new URI(url));
        return client.executeAndGet((HttpRequestBase)httpGet);
    }

    public String batchExportProcessDefinitionById(BatchExportProcessDefinitionByIdsRequest request, String id) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("token", this.token);
        String url = String.format("%s/dolphinscheduler/projects/%s/process/export?processDefinitionId=%s", this.endpoint, request.getProjectName(), id);
        httpGet.setURI(new URI(url));
        return client.executeAndGet((HttpRequestBase)httpGet);
    }
}

