/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.handle;

import com.alibaba.cola.dto.Response;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.dsv1.temp.DolphinSchedulerReader;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.metrics.enums.CollectorType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDolphinv1Handler {
    private static final Logger log = LoggerFactory.getLogger(AbstractDolphinv1Handler.class);
    protected Datasource scheduleDataSource;
    protected TaskContext taskContext;
    protected String project;
    protected DolphinSchedulerApi dolphinSchedulerApiService;
    protected DolphinSchedulerReader dolphinSchedulerReader;

    public AbstractDolphinv1Handler(Datasource scheduleDataSource, TaskContext taskContext) {
        this.scheduleDataSource = scheduleDataSource;
        this.taskContext = taskContext;
        TransformerContext.init((CollectorType)CollectorType.DolphinScheduler);
    }

    public abstract void init();

    public abstract Response preCheck(Datasource var1);

    public abstract WorkflowProjectPackage read();

    public List<WorkflowProject> getProjectList() {
        return new ArrayList<WorkflowProject>();
    }

    public Boolean getIfNeedDownloadResource() {
        if (this.taskContext.getBwmConfiguration() == null) {
            return false;
        }
        try {
            JSONObject bwmConfiguration = JSONObject.parseObject((String)this.taskContext.getBwmConfiguration());
            Boolean needDownloadResource = (Boolean)bwmConfiguration.get("resource.download.enabled");
            if (needDownloadResource == null) {
                return false;
            }
            return needDownloadResource;
        }
        catch (Exception e) {
            log.warn("conf.set.error", (Throwable)e);
            return false;
        }
    }

    public static boolean isValidVersion(String version) {
        if (StringUtils.isBlank((String)version)) {
            return false;
        }
        String pattern = "^([0-9]+(\\.[0-9]+)+)$";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(version);
        return matcher.matches();
    }

    public static boolean isValidVersion(String engineType, String version) {
        Datasource.Type type = Datasource.Type.of((String)engineType);
        if (type == null) {
            log.info("\u975e\u6cd5\u7684\u8c03\u5ea6\u5f15\u64ce\u5bfc\u81f4\u7248\u672c\u53f7\u6821\u9a8c\u5931\u8d25\uff0cengine:{}", (Object)engineType);
            return false;
        }
        if (type.getDatasourceVersion().getVersions().contains(version)) {
            return true;
        }
        log.info("\u8be5\u7248\u672c\u53f7\u4e0d\u652f\u6301\uff0cengine:{},version:{}", (Object)engineType, (Object)version);
        return false;
    }
}

