/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv1.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNodeConnect;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sql.SqlParameters;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv12WorkflowConvert {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv12WorkflowConvert.class);

    public WorkflowProjectPackage convert(DolphinSchedulerPackage aPackage) {
        if (Objects.isNull(aPackage)) {
            log.warn("DolphinSchedulerPackage is null");
            return null;
        }
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        workflowProjectPackage.setFilePath(aPackage.getPackageRoot().getAbsolutePath());
        List projects = aPackage.getProjects();
        Object projectObj = projects.get(0);
        Project project = (Project)BwmJsonUtil.deepCopy(projectObj, Project.class);
        WorkflowProject workflowProject = this.convertProject(Objects.requireNonNull(project));
        workflowProjectPackage.setWorkflowProject(workflowProject);
        List datasources = aPackage.getDatasources();
        if (!CollectionUtils.isEmpty((Collection)datasources)) {
            List datasourceList = datasources.stream().map(this::convertDataSource).collect(Collectors.toList());
            workflowProjectPackage.setDatasources(datasourceList);
        } else {
            workflowProjectPackage.setDatasources(new ArrayList());
        }
        List resources = aPackage.getResources();
        ArrayList resourceList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)resources)) {
            resources.forEach(x -> this.convertResource((ResourceInfo)x, resourceList, ""));
            resourceList.forEach(x -> x.setPath(aPackage.getPackageRoot() + x.getPath()));
        }
        workflowProjectPackage.setFiles(resourceList);
        List udfFuncs = aPackage.getUdfFuncs();
        List<Object> functionResources = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)udfFuncs)) {
            functionResources = udfFuncs.stream().map(this::convertUdfFunc).collect(Collectors.toList());
            block0: for (WorkflowFunctionResource workflowFunctionResource : functionResources) {
                for (WorkflowFileResource fileResource : resourceList) {
                    if (!fileResource.getId().equals(workflowFunctionResource.getFileResources())) continue;
                    workflowFunctionResource.setFileResources(fileResource.getName());
                    continue block0;
                }
            }
        }
        workflowProjectPackage.setFunctions(functionResources);
        ArrayList processMetaList = new ArrayList();
        Map map = Optional.ofNullable(aPackage.getProcessDefinitions()).orElse(new HashMap());
        map.values().forEach(x -> processMetaList.addAll((List)x));
        List workflowList = processMetaList.stream().map(x -> {
            Workflow workflow = this.convertWorkflow(workflowProject, (ProcessMeta)x);
            WorkflowTrigger workflowTrigger = this.convertTrigger((ProcessMeta)x);
            workflowTrigger.setProjectId(workflowProject.getProjectId());
            workflowTrigger.setProjectName(workflowProject.getName());
            workflowTrigger.setWorkflowId(workflow.getWorkflowId());
            workflowTrigger.setWorkflowName(workflow.getWorkflowName());
            workflow.setTriggers(Collections.singletonList(workflowTrigger));
            if (workflow.getCustomProperties() == null) {
                workflow.setCustomProperties(new HashMap());
            }
            workflow.getCustomProperties().put("scheduleReleaseState", x.getScheduleReleaseState());
            workflow.getCustomProperties().put("releaseState", x.getScheduleReleaseState());
            List<RelationPackage> relationPackages = this.dealNodeRelation(x.getProcessDefinitionConnects());
            workflow.setNodeRelations(relationPackages);
            workflow.setProjectId(workflowProject.getProjectId());
            return workflow;
        }).collect(Collectors.toList());
        ((Workflow)workflowList.get(0)).setFiles(resourceList);
        ((Workflow)workflowList.get(0)).setFunctions(functionResources);
        workflowProjectPackage.setWorkflowList(workflowList);
        return workflowProjectPackage;
    }

    private List<RelationPackage> dealNodeRelation(List<TaskNodeConnect> processDefinitionConnects) {
        return ((List)Optional.ofNullable(processDefinitionConnects).orElse(new ArrayList())).stream().map(x -> {
            String endPointSourceId = x.getEndPointSourceId();
            String endPointTargetId = x.getEndPointTargetId();
            return RelationPackage.builder().from(endPointSourceId).to(endPointTargetId).reType(RelationPackage.ReType.NODE).build();
        }).collect(Collectors.toList());
    }

    private WorkflowDatasource convertDataSource(DataSource datasource) {
        WorkflowDatasource resDatasource = new WorkflowDatasource();
        resDatasource.setDatasourceId(Integer.toString(datasource.getId()));
        resDatasource.setName(datasource.getName());
        resDatasource.setType(datasource.getType().getDescp());
        String connectionParams = datasource.getConnectionParams();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        try {
            Map map = (Map)GsonUtils.defaultGson.fromJson(connectionParams, type);
            resDatasource.setCustomProperties(map);
        }
        catch (Exception e) {
            log.error("map.convert.error", (Throwable)e);
        }
        return resDatasource;
    }

    private void convertResource(ResourceInfo resourceInfo, List<WorkflowFileResource> resourceList, String resourceRootPath) {
        if (resourceInfo.getDirectory() != null && resourceInfo.getDirectory().booleanValue() && resourceInfo.getChildren().size() > 0) {
            resourceInfo.getChildren().forEach(x -> this.convertResource((ResourceInfo)x, resourceList, resourceRootPath));
            return;
        }
        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
        workflowFileResource.setId(Integer.toString(resourceInfo.getId()));
        workflowFileResource.setFileId(resourceInfo.getIdValue());
        workflowFileResource.setName(resourceInfo.getName());
        if (resourceInfo.getFullName().endsWith(resourceInfo.getName())) {
            workflowFileResource.setFolder(resourceInfo.getFullName().substring(0, resourceInfo.getFullName().length() - resourceInfo.getName().length()));
            workflowFileResource.setPath(resourceRootPath + "/resource/" + resourceInfo.getFullName());
        } else {
            workflowFileResource.setFolder("");
            workflowFileResource.setPath(resourceRootPath + "/resource/" + resourceInfo.getName());
        }
        workflowFileResource.setDescription(resourceInfo.getDescription());
        workflowFileResource.setFileType(resourceInfo.getType());
        resourceList.add(workflowFileResource);
    }

    private WorkflowFunctionResource convertUdfFunc(UdfFunc udfFunc) {
        WorkflowFunctionResource wr = new WorkflowFunctionResource();
        wr.setId(Integer.toString(udfFunc.getId()));
        wr.setClassName(udfFunc.getClassName());
        wr.setName(udfFunc.getFuncName());
        wr.setArgumentsDescription(udfFunc.getArgTypes());
        wr.setType(udfFunc.getType().getDescp());
        wr.setFileResources(String.valueOf(udfFunc.getResourceId()));
        wr.setUsageExample(udfFunc.getDescription());
        return wr;
    }

    private WorkflowProject convertProject(Project project) {
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(String.valueOf(project.getId()));
        workflowProject.setName(project.getName());
        workflowProject.setDescription(project.getDescription());
        return workflowProject;
    }

    private Workflow convertWorkflow(WorkflowProject workflowProject, ProcessMeta processMeta) {
        Workflow workflow = new Workflow();
        if (Objects.isNull(processMeta.getProcessDefinitionId())) {
            workflow.setWorkflowId(processMeta.getProcessDefinitionName());
        } else {
            workflow.setWorkflowId(String.valueOf(processMeta.getProcessDefinitionId()));
        }
        workflow.setWorkflowName(processMeta.getProcessDefinitionName());
        workflow.setProjectId(workflowProject.getProjectId());
        workflow.setProjectName(processMeta.getProjectName());
        List globalParams = processMeta.getProcessDefinitionJson().getGlobalParams();
        List tasks = processMeta.getProcessDefinitionJson().getTasks();
        HashMap parammap = new HashMap();
        globalParams.forEach(x -> parammap.put(x.getProp(), x.getValue()));
        List workflowNodes = tasks.stream().map(x -> {
            WorkflowNode workflowNode = this.convertNode(workflow, (TaskNode)x);
            workflowNode.setParamMap(parammap);
            return workflowNode;
        }).collect(Collectors.toList());
        workflow.setWorkflowNodes(workflowNodes);
        Map<String, WorkflowNode> nodeMap = workflowNodes.stream().collect(Collectors.toMap(WorkflowNode::getNodeId, x -> x));
        List processDefinitionConnects = processMeta.getProcessDefinitionConnects();
        processDefinitionConnects.forEach(x -> {
            String endPointSourceId = x.getEndPointSourceId();
            String endPointTargetId = x.getEndPointTargetId();
            WorkflowNode sourceNode = (WorkflowNode)nodeMap.get(endPointSourceId);
            List<WorkflowNode> children = new ArrayList();
            if (!Objects.isNull(sourceNode)) {
                children = sourceNode.getChildren();
            }
            if (CollectionUtils.isEmpty(children)) {
                children = new ArrayList();
            }
            WorkflowNode targetNode = (WorkflowNode)nodeMap.get(endPointTargetId);
            children.add(targetNode);
        });
        return workflow;
    }

    private WorkflowTrigger convertTrigger(ProcessMeta processMeta) {
        String scheduleCrontab = processMeta.getScheduleCrontab();
        String scheduleEndTime = processMeta.getScheduleEndTime();
        String scheduleStartTime = processMeta.getScheduleStartTime();
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (Objects.nonNull(scheduleEndTime)) {
            workflowTrigger.setEndTime(LocalDateTime.parse(scheduleEndTime, formatter));
        }
        if (Objects.nonNull(scheduleStartTime)) {
            workflowTrigger.setStartTime(LocalDateTime.parse(scheduleStartTime, formatter));
        }
        workflowTrigger.setCron(scheduleCrontab);
        workflowTrigger.setProjectName(processMeta.getProjectName());
        workflowTrigger.setName(processMeta.getScheduleWarningGroupName());
        return workflowTrigger;
    }

    private WorkflowNode convertNode(Workflow workflow, TaskNode taskNode) {
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setProjectId(workflow.getProjectId());
        workflowNode.setProjectName(workflow.getProjectName());
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setWorkflowName(workflow.getWorkflowName());
        workflowNode.setNodeId(taskNode.getId());
        workflowNode.setNodeName(taskNode.getName());
        workflowNode.setNodeType(taskNode.getType().name());
        workflowNode.setPriority(Integer.valueOf(taskNode.getTaskInstancePriority().getCode()));
        workflowNode.setScript(taskNode.getParams());
        if (taskNode.getType().name().equalsIgnoreCase("SQL")) {
            SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)taskNode.getParams(), (Type)TypeToken.get(SqlParameters.class).getType());
            DbType type = parameter.getType();
            workflowNode.setDbType(type.name());
            workflowNode.setScript(this.extract(taskNode.getParams()));
            if (parameter.getLocalParams() != null) {
                if (workflowNode.getParamMap() == null) {
                    workflowNode.setParamMap(new HashMap());
                }
                workflowNode.getParamMap().putAll(parameter.getLocalParametersMap());
            }
        } else if (taskNode.getType().name().equalsIgnoreCase("SHELL")) {
            ShellParameters parameter = (ShellParameters)GsonUtils.fromJsonString((String)taskNode.getParams(), (Type)TypeToken.get(ShellParameters.class).getType());
            if (parameter.getLocalParams() != null) {
                if (workflowNode.getParamMap() == null) {
                    workflowNode.setParamMap(new HashMap());
                }
                workflowNode.getParamMap().putAll(parameter.getLocalParametersMap());
            }
            if (parameter.getResourceList() != null) {
                if (workflowNode.getFiles() == null) {
                    workflowNode.setFiles(new ArrayList());
                }
                for (ResourceInfo nodeResourceInfo : parameter.getResourceList()) {
                    WorkflowFileResource nodeFileResource = new WorkflowFileResource();
                    nodeFileResource.setName(nodeResourceInfo.getRes());
                    workflowNode.getFiles().add(nodeFileResource);
                }
            }
            workflowNode.setScript(parameter.getRawScript());
            workflowNode.setScriptPath(".sh");
        }
        return workflowNode;
    }

    private String extract(String param) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            String sql = jsonObject.getString("sql");
            if (StringUtils.isBlank((CharSequence)sql)) {
                return param;
            }
            return sql;
        }
        catch (Exception e) {
            log.error("extract sql error ", (Throwable)e);
            return param;
        }
    }
}

