/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.fastjson.serializer;

import com.alibaba.securitysdk.fastjson.serializer.JSONSerializer;
import com.alibaba.securitysdk.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleDateFormatSerializer
implements ObjectSerializer {
    private final String pattern;

    public SimpleDateFormatSerializer(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.out.writeNull();
            return;
        }
        Date date = (Date)object;
        SimpleDateFormat format = new SimpleDateFormat(this.pattern, serializer.locale);
        format.setTimeZone(serializer.timeZone);
        String text = format.format(date);
        serializer.write(text);
    }
}

