/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.html.dom;

import com.alibaba.securitysdk.org.apache.html.dom.HTMLDocumentImpl;
import com.alibaba.securitysdk.org.apache.html.dom.HTMLElementImpl;
import com.alibaba.securitysdk.org.w3c.dom.Node;
import com.alibaba.securitysdk.org.w3c.dom.NodeList;
import com.alibaba.securitysdk.org.w3c.dom.Text;
import com.alibaba.securitysdk.org.w3c.dom.html.HTMLElement;
import com.alibaba.securitysdk.org.w3c.dom.html.HTMLOptionElement;
import com.alibaba.securitysdk.org.w3c.dom.html.HTMLSelectElement;

public class HTMLOptionElementImpl
extends HTMLElementImpl
implements HTMLOptionElement {
    private static final long serialVersionUID = -4486774554137530907L;

    public boolean getDefaultSelected() {
        return this.getBinary("default-selected");
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.setAttribute("default-selected", defaultSelected);
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            text.append(((Text)child).getData());
        }
        return text.toString();
    }

    public void setText(String text) {
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            this.removeChild(child);
            child = next;
        }
        this.insertBefore((Node)this.getOwnerDocument().createTextNode(text), this.getFirstChild());
    }

    public int getIndex() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && !(parent instanceof HTMLSelectElement); parent = parent.getParentNode()) {
        }
        if (parent != null) {
            NodeList options = ((HTMLElement)parent).getElementsByTagName("OPTION");
            for (int i = 0; i < options.getLength(); ++i) {
                if (options.item(i) != this) continue;
                return i;
            }
        }
        return -1;
    }

    public void setIndex(int index) {
        NodeList options;
        Node parent;
        for (parent = this.getParentNode(); parent != null && !(parent instanceof HTMLSelectElement); parent = parent.getParentNode()) {
        }
        if (parent != null && (options = ((HTMLElement)parent).getElementsByTagName("OPTION")).item(index) != this) {
            this.getParentNode().removeChild((Node)this);
            Node item = options.item(index);
            item.getParentNode().insertBefore((Node)this, item);
        }
    }

    public boolean getDisabled() {
        return this.getBinary("disabled");
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    public String getLabel() {
        return this.capitalize(this.getAttribute("label"));
    }

    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    public boolean getSelected() {
        return this.getBinary("selected");
    }

    public void setSelected(boolean selected) {
        this.setAttribute("selected", selected);
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public HTMLOptionElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

