/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(EmrNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity dwNode) {
        return CodeProgramType.matchEngine((String)dwNode.getType(), (CalcEngineType)CalcEngineType.EMR);
    }

    @Override
    public SpecScriptRuntime toSpecScriptRuntime(DwNodeEntity scr) {
        SpecScriptRuntime runtime = super.toSpecScriptRuntime(scr);
        SpecScriptRuntime emrRuntime = new SpecScriptRuntime();
        BeanUtils.copyProperties((Object)runtime, (Object)emrRuntime);
        CodeModel code = CodeModelFactory.getCodeModel((String)scr.getType(), (String)scr.getCode());
        HashMap emrJobConfig = Maps.newHashMap();
        HashMap sparkConf = Maps.newHashMap();
        Optional.ofNullable((EmrCode)code.getCodeModel()).flatMap(emrCode -> Optional.ofNullable(emrCode.getLauncher()).map(EmrLauncher::getAllocationSpec)).ifPresent(allocSpecMap -> {
            EmrAllocationSpec allocSpec = EmrAllocationSpec.of((Map)allocSpecMap);
            emrJobConfig.put("priority", allocSpec.getPriority());
            emrJobConfig.put("cores", allocSpec.getVcores());
            emrJobConfig.put("memory", allocSpec.getMemory());
            emrJobConfig.put("queue", allocSpec.getQueue());
            emrJobConfig.put("submitter", allocSpec.getUserName());
            Optional.ofNullable(allocSpec.getDataworksSessionDisable()).ifPresent(disable -> emrJobConfig.put("DATAWORKS_SESSION_DISABLE", disable));
            Optional.ofNullable(allocSpec.getEnableJdbcSql()).ifPresent(enable -> emrJobConfig.put("ENABLE_SPARKSQL_JDBC", enable));
            Optional.ofNullable(allocSpec.getReuseSession()).ifPresent(reuse -> emrJobConfig.put("REUSE_SESSION", reuse));
            Optional.ofNullable(allocSpec.getUseGateway()).ifPresent(useGateway -> emrJobConfig.put("USE_GATEWAY", useGateway));
            Optional.ofNullable(allocSpec.getBatchMode()).ifPresent(batchMode -> emrJobConfig.put("FLOW_SKIP_SQL_ANALYZE", batchMode));
            allocSpecMap.entrySet().stream().filter(ent -> ReflectUtils.getPropertyFields((Object)allocSpec).stream().noneMatch(f -> f.getName().equals(ent.getKey()))).filter(ent -> !EmrAllocationSpec.UPPER_KEYS.contains(ent.getKey())).forEach(ent -> sparkConf.put((String)ent.getKey(), ent.getValue()));
        });
        emrRuntime.setEmrJobConfig((Map)emrJobConfig);
        emrRuntime.setSparkConf((Map)sparkConf);
        return emrRuntime;
    }

    @Override
    public String toSpecScriptContent(DwNodeEntity dmNodeBO) {
        CodeModel code = CodeModelFactory.getCodeModel((String)dmNodeBO.getType(), (String)dmNodeBO.getCode());
        return code.getSourceCode();
    }
}

