/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ComponentSqlCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.SqlComponentCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponent;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeContext;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.File;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.FileNodeCfg;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.FileNodeInputOutput;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.client.FileNodeInputOutputContext;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class FileDetailEntityAdapter
implements DwNodeEntity {
    private File file;
    private FileNodeCfg fileNodeCfg;

    @Override
    public String getUuid() {
        return Optional.ofNullable(this.file).map(File::getFileId).map(String::valueOf).orElse(null);
    }

    @Override
    public Long getBizId() {
        return Optional.ofNullable(this.file).map(File::getBizId).orElse(null);
    }

    @Override
    public String getBizName() {
        return null;
    }

    @Override
    public String getResourceGroupName() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getResourceGroupIdentifier).orElse(null);
    }

    @Override
    public Long getResourceGroupId() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getResgroupId).orElse(null);
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.file).map(File::getFileName).orElse(null);
    }

    @Override
    public String getType() {
        return Optional.ofNullable(this.file).map(File::getFileType).map(CodeProgramType::getNodeTypeByCode).map(Enum::name).orElse(null);
    }

    @Override
    public Integer getTypeId() {
        return Optional.ofNullable(this.file).map(File::getFileType).orElse(null);
    }

    @Override
    public String getCronExpress() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getCronExpress).orElse(null);
    }

    @Override
    public Date getStartEffectDate() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getStartEffectDate).orElse(null);
    }

    @Override
    public Integer getIsAutoParse() {
        return Optional.ofNullable(this.file).map(File::getIsAutoParse).orElseGet(() -> Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getIsAutoParse).orElse(null));
    }

    @Override
    public Date getEndEffectDate() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getEndEffectDate).orElse(null);
    }

    @Override
    public String getResourceGroup() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getResourceGroupIdentifier).orElse(null);
    }

    @Override
    public String getDiResourceGroup() {
        return null;
    }

    @Override
    public String getDiResourceGroupName() {
        return null;
    }

    @Override
    public String getCodeMode() {
        return null;
    }

    @Override
    public Boolean getStartRightNow() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getStartRightNow).orElse(null);
    }

    @Override
    public RerunMode getRerunMode() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getReRunAble).map(code -> {
            try {
                return RerunMode.getByValue(code);
            }
            catch (Exception e) {
                return RerunMode.UNKNOWN;
            }
        }).orElse(RerunMode.UNKNOWN);
    }

    @Override
    public Integer getNodeType() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getNodeType).orElse(null);
    }

    @Override
    public Boolean getPauseSchedule() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getIsStop).map(isStop -> isStop == 1).orElse(null);
    }

    @Override
    @NotNull
    public NodeUseType getNodeUseType() {
        return Optional.ofNullable(this.file).map(File::getUseType).map(code -> {
            try {
                return NodeUseType.getNodeUseTypeByValue(code);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(NodeUseType.SCHEDULED);
    }

    @Override
    public String getRef() {
        return Optional.ofNullable(this.file).map(File::getReference).orElse(null);
    }

    @Override
    public String getFolder() {
        return Optional.ofNullable(this.file).map(File::getFileFolderPath).orElse(null);
    }

    @Override
    public Boolean getRoot() {
        return null;
    }

    @Override
    public String getConnection() {
        return Optional.ofNullable(this.file).map(File::getConnName).orElse(null);
    }

    @Override
    public String getCode() {
        return Optional.ofNullable(this.file).map(File::getContent).orElse(null);
    }

    @Override
    public String getParameter() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getParaValue).orElse(null);
    }

    @Override
    public List<NodeContext> getInputContexts() {
        if (!Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getInputContextList).isPresent()) {
            return null;
        }
        return this.fileNodeCfg.getInputContextList().stream().filter(Objects::nonNull).map(this::toNodeContext).collect(Collectors.toList());
    }

    @Override
    public List<NodeContext> getOutputContexts() {
        if (!Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getOutputContextList).isPresent()) {
            return null;
        }
        return this.fileNodeCfg.getOutputContextList().stream().filter(Objects::nonNull).map(this::toNodeContext).collect(Collectors.toList());
    }

    @Override
    public List<NodeIo> getInputs() {
        if (!Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getInputList).isPresent()) {
            return null;
        }
        return this.fileNodeCfg.getInputList().stream().filter(Objects::nonNull).map(this::toNodeIo).collect(Collectors.toList());
    }

    @Override
    public List<NodeIo> getOutputs() {
        if (!Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getOutputList).isPresent()) {
            return null;
        }
        return this.fileNodeCfg.getOutputList().stream().filter(Objects::nonNull).map(this::toNodeIo).collect(Collectors.toList());
    }

    @Override
    public List<DwNodeEntity> getInnerNodes() {
        return new ArrayList<DwNodeEntity>();
    }

    @Override
    public String getDescription() {
        return Optional.ofNullable(this.file).map(File::getFileDesc).orElse(null);
    }

    @Override
    public Integer getTaskRerunTime() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getTaskRerunTime).orElse(null);
    }

    @Override
    public Integer getTaskRerunInterval() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getTaskRerunInterval).map(Math::toIntExact).orElse(null);
    }

    @Override
    public Integer getDependentType() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getDependentType).orElse(null);
    }

    @Override
    public Integer getCycleType() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getCycleType).orElse(null);
    }

    @Override
    public Date getLastModifyTime() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getLastModifyTime).orElse(null);
    }

    @Override
    public String getLastModifyUser() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getLastModifyUser).orElse(null);
    }

    @Override
    public Integer getMultiInstCheckType() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getMultiinstCheckType).orElse(null);
    }

    @Override
    public Integer getPriority() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getPriority).orElse(null);
    }

    @Override
    public String getDependentDataNode() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getDependentDataNode).orElse(null);
    }

    @Override
    public String getOwner() {
        return Optional.ofNullable(this.file).map(File::getOwner).orElse(null);
    }

    @Override
    public String getOwnerName() {
        return Optional.ofNullable(this.file).map(File::getOwnerName).orElse(null);
    }

    @Override
    public String getExtraConfig() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getExtConfig).orElse(null);
    }

    @Override
    public String getExtraContent() {
        return Optional.ofNullable(this.file).map(File::getExtraContent).orElse(null);
    }

    @Override
    public String getTtContent() {
        return Optional.ofNullable(this.file).map(File::getTtContent).orElse(null);
    }

    @Override
    public String getAdvanceSettings() {
        return Optional.ofNullable(this.file).map(File::getAdvanceSettings).orElse(null);
    }

    @Override
    public String getExtend() {
        return Optional.ofNullable(this.file).map(File::getExtend).orElse(null);
    }

    @Override
    public SpecComponent getComponent() {
        return Optional.ofNullable(CodeProgramType.getNodeTypeByName((String)this.getType())).map(type -> {
            if (CodeProgramType.COMPONENT_SQL.name().equalsIgnoreCase(type.name())) {
                return this.getComponentSql();
            }
            if (CodeProgramType.SQL_COMPONENT.name().equalsIgnoreCase(type.name())) {
                return this.getSqlComponent();
            }
            return null;
        }).orElse(null);
    }

    @Override
    public String getImageId() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getImageId).orElse(null);
    }

    @Override
    public Long getCalendarId() {
        return DwNodeEntity.super.getCalendarId();
    }

    @Override
    public Integer getStreamLaunchMode() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getStreamLaunchMode).orElse(null);
    }

    @Override
    public Boolean getIgnoreBranchConditionSkip() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getIgnoreBranchConditionSkip).orElse(null);
    }

    @Override
    public Integer getAlisaTaskKillTimeout() {
        return Optional.ofNullable(this.fileNodeCfg).map(FileNodeCfg::getAlisaTaskKillTimeout).orElse(null);
    }

    @Override
    public Long getParentId() {
        return Optional.ofNullable(this.file).map(File::getParentId).orElse(null);
    }

    @Override
    public String getCu() {
        return DwNodeEntity.super.getCu();
    }

    @Override
    public String getStorageUri() {
        return Optional.ofNullable(this.file).map(File::getStorageUri).orElse(null);
    }

    private NodeContext toNodeContext(FileNodeInputOutputContext nodeInputOutputContext) {
        if (nodeInputOutputContext == null) {
            return null;
        }
        NodeContext nodeContext = new NodeContext();
        nodeContext.setType(nodeInputOutputContext.getType());
        nodeContext.setParamName(nodeInputOutputContext.getParamName());
        nodeContext.setParamValue(nodeInputOutputContext.getParamValue());
        nodeContext.setParamType(nodeInputOutputContext.getParamType());
        nodeContext.setParseType(nodeInputOutputContext.getParseType());
        nodeContext.setDescription(nodeInputOutputContext.getDescription());
        nodeContext.setEditable(nodeInputOutputContext.getEditable());
        nodeContext.setNodeId(nodeInputOutputContext.getNodeId());
        nodeContext.setParamNodeId(nodeInputOutputContext.getParamNodeId());
        nodeContext.setOutput(nodeInputOutputContext.getOutput());
        return nodeContext;
    }

    private NodeIo toNodeIo(FileNodeInputOutput nodeInputOutput) {
        if (nodeInputOutput == null) {
            return null;
        }
        NodeIo nodeIo = new NodeIo();
        nodeIo.setData(nodeInputOutput.getStr());
        nodeIo.setParseType(nodeInputOutput.getParseType());
        nodeIo.setRefTableName(nodeInputOutput.getRefTableName());
        return nodeIo;
    }

    private SpecComponent getSqlComponent() {
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.SQL_COMPONENT.name(), (String)this.getCode());
        SpecComponent com = Optional.ofNullable((SqlComponentCode)codeModel.getCodeModel()).map(SqlComponentCode::getConfig).orElse(new SpecComponent());
        com.setId(this.getUuid());
        com.setName(this.getName());
        com.setOwner(this.getOwner());
        com.setDescription(this.getDescription());
        com.setInputs(com.getInputs());
        com.setOutputs(com.getOutputs());
        SpecScript script = new SpecScript();
        script.setContent(((SqlComponentCode)codeModel.getCodeModel()).getCode());
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setCommand(CodeProgramType.SQL_COMPONENT.getName());
        runtime.setCommandTypeId(Integer.valueOf(CodeProgramType.SQL_COMPONENT.getCode()));
        script.setRuntime(runtime);
        com.setScript(script);
        return com;
    }

    private SpecComponent getComponentSql() {
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.COMPONENT_SQL.name(), (String)this.getCode());
        SpecComponent com = Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getConfig()).orElse(new SpecComponent());
        Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getComponent()).map(ComponentSqlCode.ComponentInfo::getId).map(String::valueOf).ifPresent(arg_0 -> ((SpecComponent)com).setId(arg_0));
        Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getComponent()).map(ComponentSqlCode.ComponentInfo::getName).ifPresent(arg_0 -> ((SpecComponent)com).setName(arg_0));
        HashMap<String, String> metadata = new HashMap<String, String>();
        Optional.ofNullable((ComponentSqlCode)codeModel.getCodeModel()).map(ComponentSqlCode::getComponent).map(ComponentSqlCode.ComponentInfo::getVersion).ifPresent(version -> metadata.put("version", (String)version));
        metadata.put("id", com.getId());
        com.setMetadata(metadata);
        return com;
    }

    public File getFile() {
        return this.file;
    }

    public FileNodeCfg getFileNodeCfg() {
        return this.fileNodeCfg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileNodeCfg(FileNodeCfg fileNodeCfg) {
        this.fileNodeCfg = fileNodeCfg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileDetailEntityAdapter)) {
            return false;
        }
        FileDetailEntityAdapter other = (FileDetailEntityAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        FileNodeCfg this$fileNodeCfg = this.getFileNodeCfg();
        FileNodeCfg other$fileNodeCfg = other.getFileNodeCfg();
        return !(this$fileNodeCfg == null ? other$fileNodeCfg != null : !((Object)this$fileNodeCfg).equals(other$fileNodeCfg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileDetailEntityAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        FileNodeCfg $fileNodeCfg = this.getFileNodeCfg();
        result = result * 59 + ($fileNodeCfg == null ? 43 : ((Object)$fileNodeCfg).hashCode());
        return result;
    }

    public String toString() {
        return "FileDetailEntityAdapter(file=" + this.getFile() + ", fileNodeCfg=" + this.getFileNodeCfg() + ")";
    }
}

