/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.impl;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.common.spec.domain.dw.types.ProductModule;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeInstanceModeType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRerunModeType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecRuntimeResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Datasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.NodeSpecAdapter;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntityAdapter;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.service.AbstractPackageFileService;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.ZipUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksSpecPackageFileService
extends AbstractPackageFileService<DataWorksPackage> {
    private static final Logger log = LoggerFactory.getLogger(DataWorksSpecPackageFileService.class);
    private static final String SPEC_FILE_SUFFIX = ".schedule.json";
    private static final String SPEC_FORMAT_FILE_NAME = "SPEC.FORMAT";

    protected boolean isProjectRoot(File file) {
        return false;
    }

    public void load(DataWorksPackage packageObj) throws Exception {
    }

    public DataWorksPackage getPackage() throws Exception {
        return null;
    }

    public void write(DataWorksPackage packageModelObject, File targetPackageFile) throws Exception {
        String targetDirName = RegExUtils.replaceAll((String)targetPackageFile.getName(), (String)"\\..*$", (String)"");
        File targetTmp = new File(targetPackageFile.getParentFile(), ".tmp");
        if (targetTmp.exists()) {
            FileUtils.deleteDirectory((File)targetTmp);
        }
        File targetWorkspace = new File(targetTmp, targetDirName);
        FileUtils.forceMkdir((File)targetWorkspace);
        this.writeSpecFormatFile(targetWorkspace);
        this.writeDataStudioDirectory(packageModelObject, targetWorkspace);
        this.writeDatasourceDirectory(packageModelObject, targetWorkspace);
        if (Config.get().isZipSpec()) {
            ZipUtils.zipDir((File)targetTmp, (File)targetPackageFile);
            log.info("zipped file: {}", (Object)targetPackageFile);
        } else {
            log.warn("unzip file : {}", (Object)targetWorkspace);
        }
    }

    private void writeDatasourceDirectory(DataWorksPackage packageModelObject, File targetWorkspace) throws IOException {
        File rootDir = new File(targetWorkspace, ProductModule.DATA_SOURCE.getName());
        if (rootDir.exists()) {
            log.info("deleting existing root directory: {}", (Object)rootDir);
            FileUtils.deleteDirectory((File)rootDir);
        }
        Optional.ofNullable(packageModelObject.getDwProject()).map(Project::getDatasources).map(ListUtils::emptyIfNull).ifPresent(datasources -> ((Stream)datasources.stream().parallel()).forEach(dmDatasourceBO -> {
            String path = String.join((CharSequence)File.separator, dmDatasourceBO.getType(), StringUtils.defaultIfBlank((CharSequence)dmDatasourceBO.getSubType(), (CharSequence)dmDatasourceBO.getType()), Arrays.stream(EnvType.values()).filter(env -> Objects.equals(env.name(), dmDatasourceBO.getEnvType())).findAny().orElse(EnvType.PRD).name(), dmDatasourceBO.getName());
            path = String.join((CharSequence)File.separator, rootDir.getAbsolutePath(), path);
            File dataSourceDir = new File(path);
            boolean ret = dataSourceDir.mkdirs();
            log.info("create data source directory: {}, {}", (Object)dataSourceDir, (Object)ret);
            File dataSourceFile = new File(dataSourceDir, dmDatasourceBO.getName() + ".json");
            try {
                FileUtils.writeStringToFile((File)dataSourceFile, (String)this.getDataSourceSpec((Datasource)dmDatasourceBO), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private String getDataSourceSpec(Datasource datasource) {
        Specification specSpecification = new Specification();
        specSpecification.setVersion(SpecVersion.V_1_1_0.getLabel());
        specSpecification.setKind(ProductModule.DATA_SOURCE.getName());
        HashMap metadata = new HashMap();
        specSpecification.setMetadata(metadata);
        DataWorksWorkflowSpec dwSpec = new DataWorksWorkflowSpec();
        specSpecification.setSpec((Spec)dwSpec);
        dwSpec.setDatasources(Optional.ofNullable(datasource).map(ds -> {
            SpecDatasource specDatasource = new SpecDatasource();
            specDatasource.setId(ds.getName());
            specDatasource.setName(ds.getName());
            specDatasource.setMetadata(metadata);
            specDatasource.setType(ds.getType());
            specDatasource.setSubType(ds.getSubType());
            specDatasource.setConfig(ds.getConnection());
            return specDatasource;
        }).map(Collections::singletonList).orElse(Collections.emptyList()));
        return SpecUtil.writeToSpec((Specification)specSpecification);
    }

    private void writeDataStudioDirectory(DataWorksPackage packageModelObject, File targetWorkspace) throws IOException {
        File dataStudioDir = new File(targetWorkspace, ProductModule.DATA_STUDIO.getName());
        FileUtils.forceMkdir((File)dataStudioDir);
        this.writeWorkflows(packageModelObject, dataStudioDir);
    }

    private void writeSpecFormatFile(File targetWorkspace) {
        try {
            FileUtils.writeStringToFile((File)new File(targetWorkspace, SPEC_FORMAT_FILE_NAME), (String)"", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeWorkflows(DataWorksPackage packageModelObject, File targetWorkspace) {
        ((List)Optional.ofNullable(packageModelObject).map(DataWorksPackage::getDwProject).map(Project::getWorkflows).orElse(new ArrayList())).forEach(w -> {
            block2: {
                try {
                    this.writeWorkflow((Workflow)w, targetWorkspace);
                }
                catch (Exception e) {
                    log.error("write workflow error: ", (Throwable)e);
                    if (Config.get().isSpecContinueWithError()) break block2;
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void writeWorkflow(Workflow workflow, File targetWorkspace) throws IOException {
        File workflowDir = this.makeWorkflowDirectory(targetWorkspace, workflow);
        log.info("workflow directory: {}", (Object)workflowDir);
        this.writeWorkflowNodes(workflowDir, workflow);
        this.writeResourceFiles(workflowDir, workflow.getResources());
    }

    private void writeWorkflowNodes(File workflowDir, Workflow workflow) {
        ListUtils.emptyIfNull(workflow.getNodes()).forEach(node -> {
            try {
                this.writeNodeSpec(workflowDir, (Node)node);
                this.writeNodeCode(workflowDir, (Node)node);
                TransformerContext.getCollector().markSuccessSpecProcess(workflow.getName(), node.getName());
            }
            catch (Throwable e) {
                TransformerContext.getCollector().markFailedSpecProcess(workflow.getName(), node.getName());
                throw e;
            }
        });
    }

    private void writeResourceFiles(File workflowPath, List<Resource> resources) {
        resources.stream().filter(r -> r instanceof DwResource).forEach(resource -> {
            this.writeResourceSpec(workflowPath, (Resource)resource);
            this.writeResourceFile(workflowPath, (Resource)resource);
        });
    }

    private void writeResourceSpec(File workflowDir, Resource resource) {
        NodeSpecAdapter adapter = new NodeSpecAdapter();
        SpecHandlerContext context = new SpecHandlerContext();
        context.setLocale(this.locale);
        Specification<DataWorksWorkflowSpec> specification = adapter.getResourceSpecObject(resource, context);
        String spec = SpecUtil.writeToSpec(specification);
        File resFile = new File(workflowDir, Joiner.on((String)File.separator).join((Object)resource.getFolder(), (Object)(resource.getName() + SPEC_FILE_SUFFIX), new Object[0]));
        try {
            FileUtils.writeStringToFile((File)resFile, (String)spec, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeResourceFile(File workflowPath, Resource resource) {
        try {
            File resFile = new File(workflowPath, Joiner.on((String)File.separator).join((Object)resource.getFolder(), (Object)resource.getName(), new Object[0]));
            FileUtils.copyFile((File)new File(((DwResource)resource).getLocalPath()), (File)resFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeNodeCode(File workflowDir, Node node) {
        CodeProgramType prgType = CodeProgramType.of((String)node.getType());
        File nodeDir = new File(workflowDir, Joiner.on((String)File.separator).join((Object)node.getFolder(), (Object)node.getName(), new Object[0]));
        String fileName = Optional.ofNullable(prgType.getExtension()).map(ext -> node.getName() + ext).orElse(node.getName());
        File codeFile = new File(nodeDir, fileName);
        try {
            CodeModel code = CodeModelFactory.getCodeModel((String)node.getType(), (String)node.getCode());
            if (code.getCodeModel() instanceof EmrCode) {
                String content = code.getCodeModel().getSourceCode();
                FileUtils.writeStringToFile((File)codeFile, (String)content, (Charset)StandardCharsets.UTF_8);
            } else {
                FileUtils.writeStringToFile((File)codeFile, (String)node.getCode(), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeNodeSpec(File workflowDir, Node node) {
        NodeSpecAdapter adapter = new NodeSpecAdapter();
        SpecHandlerContext context = new SpecHandlerContext();
        context.setLocale(this.locale);
        node.setGlobalUuid(UUID.randomUUID().toString());
        this.completeNodeFolder(node);
        Specification<DataWorksWorkflowSpec> specification = adapter.getNodeSpecObject(new DwNodeEntityAdapter((DwNode)node), context);
        String spec = SpecUtil.writeToSpec(specification);
        File nodeDir = new File(workflowDir, Joiner.on((String)File.separator).join((Object)node.getFolder(), (Object)node.getName(), new Object[0]));
        File specFile = new File(nodeDir, node.getName() + SPEC_FILE_SUFFIX);
        try {
            FileUtils.writeStringToFile((File)specFile, (String)spec, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SpecNode toSpecNode(File workflowDir, Node node) {
        SpecNode specNode = new SpecNode();
        specNode.setId(node.getGlobalUuid());
        specNode.setName(node.getName());
        specNode.setOwner(node.getOwner());
        if (Objects.equals((Object)node.getNodeUseType(), (Object)NodeUseType.SKIP)) {
            specNode.setRecurrence(NodeRecurrenceType.SKIP);
        } else if (BooleanUtils.isTrue((Boolean)node.getPauseSchedule())) {
            specNode.setRecurrence(NodeRecurrenceType.PAUSE);
        } else {
            specNode.setRecurrence(NodeRecurrenceType.NORMAL);
        }
        node.setRerunMode(Optional.ofNullable(node.getRerunMode()).orElse(RerunMode.ALL_ALLOWED));
        switch (node.getRerunMode()) {
            case FAILURE_ALLOWED: {
                specNode.setRerunMode(NodeRerunModeType.FAILURE_ALLOWED);
                break;
            }
            case ALL_ALLOWED: {
                specNode.setRerunMode(NodeRerunModeType.ALL_ALLOWED);
                break;
            }
            case ALL_DENIED: {
                specNode.setRerunMode(NodeRerunModeType.ALL_DENIED);
            }
        }
        specNode.setRerunTimes(node.getTaskRerunTime());
        specNode.setRerunInterval(node.getTaskRerunInterval());
        if (StringUtils.isNotBlank((CharSequence)node.getResourceGroup())) {
            SpecRuntimeResource rt = new SpecRuntimeResource();
            rt.setResourceGroup(node.getResourceGroup());
            specNode.setRuntimeResource(rt);
        }
        if (BooleanUtils.isTrue((Boolean)node.getStartRightNow())) {
            specNode.setInstanceMode(NodeInstanceModeType.IMMEDIATELY);
        } else {
            specNode.setInstanceMode(NodeInstanceModeType.T_PLUS_1);
        }
        this.setScript(workflowDir, node, specNode);
        specNode.setInputs(ListUtils.emptyIfNull(node.getInputs()).stream().map(in -> {
            SpecNodeOutput specArtifact = new SpecNodeOutput();
            specArtifact.setData(in.getData());
            specArtifact.setRefTableName(in.getRefTableName());
            specArtifact.setArtifactType(ArtifactType.NODE_OUTPUT);
            return specArtifact;
        }).collect(Collectors.toList()));
        specNode.setOutputs(ListUtils.emptyIfNull(node.getOutputs()).stream().map(in -> {
            SpecNodeOutput specArtifact = new SpecNodeOutput();
            specArtifact.setData(in.getData());
            specArtifact.setRefTableName(in.getRefTableName());
            specArtifact.setArtifactType(ArtifactType.NODE_OUTPUT);
            return specArtifact;
        }).collect(Collectors.toList()));
        if (node.getConnection() != null) {
            SpecDatasource datasource = new SpecDatasource();
            datasource.setName(node.getConnection());
            specNode.setDatasource(datasource);
        }
        return specNode;
    }

    private void setScript(File workflowDir, Node node, SpecNode specNode) {
        SpecScript script = new SpecScript();
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        CalcEngineType engineType = CodeProgramType.of((String)node.getType()).getCalcEngineType();
        runtime.setCommand(node.getType());
        runtime.setEngine(engineType.getName());
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)node.getType(), null);
        runtime.setTemplate(codeModel.getTemplate());
        script.setRuntime(runtime);
        script.setId(specNode.getId());
        script.setParameters(DataWorksSpecPackageFileService.toNodeParameters(node));
        CodeProgramType prgType = CodeProgramType.valueOf((String)node.getType());
        String pathToFile = Joiner.on((String)File.separator).join((Object)node.getFolder(), (Object)Optional.ofNullable(prgType.getExtension()).map(ext -> node.getName() + ext).orElse(node.getName()), new Object[0]);
        File folder = new File(workflowDir, pathToFile);
        ArrayList<String> paths = new ArrayList<String>();
        while (!folder.equals(workflowDir)) {
            folder = folder.getParentFile();
            paths.add(folder.getName());
        }
        paths.add(workflowDir.getParentFile().getName());
        Object[] arr = new String[paths.size()];
        paths.toArray(arr);
        CollectionUtils.reverseArray((Object[])arr);
        script.setPath(Joiner.on((String)File.separator).join(arr));
        specNode.setScript(script);
    }

    private static List<SpecVariable> toNodeParameters(Node node) {
        return Arrays.stream(StringUtils.split((String)StringUtils.trim((String)((String)StringUtils.defaultIfBlank((CharSequence)node.getParameter(), (CharSequence)""))), (String)" ")).filter(StringUtils::isNotBlank).map(kv -> StringUtils.split((String)kv, (String)"=")).filter(Objects::nonNull).filter(kvPair -> ((String[])kvPair).length > 0).map(kvPair -> {
            SpecVariable var = new SpecVariable();
            var.setName(kvPair[0]);
            var.setType(VariableType.CONSTANT);
            var.setScope(VariableScopeType.NODE_PARAMETER);
            var.setValue(((String[])kvPair).length > 1 ? kvPair[1] : "");
            return var;
        }).collect(Collectors.toList());
    }

    private void completeNodeFolder(Node node) {
        CodeProgramType prgType = CodeProgramType.valueOf((String)node.getType());
        CalcEngineType engineType = prgType.getCalcEngineType();
        LabelType labelType = prgType.getLabelType();
        ArrayList paths = new ArrayList();
        Optional.ofNullable(engineType).ifPresent(e -> paths.add(e.getDisplayName(this.locale)));
        Optional.ofNullable(labelType).ifPresent(e -> paths.add(e.getDisplayName(this.locale)));
        node.setFolder(Joiner.on((String)File.separator).join(paths));
    }

    private File makeWorkflowDirectory(File targetWorkspace, Workflow workflow) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        WorkflowType type = Optional.ofNullable(workflow.getType()).orElse(WorkflowType.BUSINESS);
        switch (type) {
            case BUSINESS: {
                paths.add(ModelTreeRoot.BIZ_ROOT.getDisplayName(this.locale));
                break;
            }
            case OLD_WORKFLOW: {
                paths.add(ModelTreeRoot.WORK_FLOW_ROOT_NEW.getDisplayName(this.locale));
                break;
            }
            case MANUAL_BUSINESS: {
                paths.add(ModelTreeRoot.MANUAL_WORK_FLOW_ROOT.getDisplayName(this.locale));
            }
        }
        paths.add(workflow.getName());
        File directory = new File(targetWorkspace, Joiner.on((String)File.separator).join(paths));
        FileUtils.forceMkdir((File)directory);
        return directory;
    }
}

