/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.objects.types;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;

public enum WorkflowType {
    BUSINESS(0),
    MANUAL_BUSINESS(1),
    OLD_WORKFLOW(2);

    private Integer value;

    private WorkflowType(Integer value) {
        this.value = value;
    }

    public static WorkflowType getWorkflowTypeByValue(Integer typeValue) {
        for (WorkflowType type : WorkflowType.values()) {
            if (!type.getValue().equals(typeValue)) continue;
            return type;
        }
        throw new RuntimeException("unknown workflow type value: " + typeValue);
    }

    public Integer getValue() {
        return this.value;
    }

    public static WorkflowType getWorkflowTypeByUseType(NodeUseType useType) {
        if (useType == null) {
            return null;
        }
        switch (useType) {
            case SCHEDULED: 
            case SKIP: {
                return BUSINESS;
            }
            case MANUAL_WORKFLOW: 
            case MANUAL: {
                return MANUAL_BUSINESS;
            }
        }
        throw new RuntimeException("unknown use type: " + (Object)((Object)useType));
    }
}

