/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2;

public enum IdeFolderItemType {
    TABLE(1, "TABLE"),
    CODE(2, "CODE"),
    QUERY(3, "QUERY"),
    RESOURCE(4, "RESOURCE"),
    MANUAL_TASK(5, "MANUAL_TASK"),
    FUNCTION(6, "FUNCTION"),
    RECYCLE(7, "RECYCLE"),
    TABLE_ROOT(8, "\u8868"),
    DATAFLOW_ROOT(9, "\u6570\u636e\u6d41"),
    DATA_FLOW(10, "dataflow"),
    GROUP(11, "GROUP"),
    REALTIME(12, "REALTIME"),
    DATA_STUDIO_PLANTASK(13, "DATA_STUDIO_PLANTASK"),
    DATA_STUDIO_QUERY(14, "DATA_STUDIO_QUERY"),
    INDEX(20, "INDEX"),
    MANUAL_BIZ(21, "MANUAL_TASK"),
    COMPONENT(22, "COMPONENT");

    private Integer code;
    private String alias;

    private IdeFolderItemType(Integer code, String alias) {
        this.code = code;
        this.alias = alias;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getAlias() {
        return this.alias;
    }

    public static IdeFolderItemType getByCode(Integer code) {
        for (IdeFolderItemType type : IdeFolderItemType.values()) {
            if (!code.equals(type.getCode())) continue;
            return type;
        }
        return null;
    }

    public static IdeFolderItemType getByAlias(String alias) {
        for (IdeFolderItemType type : IdeFolderItemType.values()) {
            if (!alias.equals(type.getAlias())) continue;
            return type;
        }
        return null;
    }

    public static IdeFolderItemType getByUseType(Integer useType) {
        switch (useType) {
            case 0: 
            case 3: {
                return CODE;
            }
            case 1: {
                return MANUAL_TASK;
            }
            case 2: {
                return MANUAL_BIZ;
            }
            case 8: {
                return DATA_FLOW;
            }
            case 10: {
                return QUERY;
            }
            case 12: {
                return DATA_STUDIO_QUERY;
            }
            case 13: {
                return DATA_STUDIO_PLANTASK;
            }
            case 30: {
                return COMPONENT;
            }
        }
        return null;
    }

    public String toString() {
        return this.code.toString();
    }
}

