/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.workflow.migration.core;

import com.aliyun.migration.api.context.TaskContext;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private final String jobID;
    private final String taskID;
    protected TaskContext taskContext;
    private long taskStartTimeMS = 0L;
    private long taskEndTimeMS = 0L;

    public Task(String jobId, String taskId, TaskContext taskContext) {
        this.jobID = jobId;
        this.taskID = taskId;
        this.taskContext = taskContext;
    }

    public abstract void kill();

    public boolean init() throws Throwable {
        return true;
    }

    public String getJobID() {
        return this.jobID;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public long getTaskStartTimeMS() {
        return this.taskStartTimeMS;
    }

    public long getTaskEndTimeMS() {
        return this.taskEndTimeMS;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setTaskStartTimeMS(long taskStartTimeMS) {
        this.taskStartTimeMS = taskStartTimeMS;
    }

    public void setTaskEndTimeMS(long taskEndTimeMS) {
        this.taskEndTimeMS = taskEndTimeMS;
    }
}

