/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.loggers;

import com.alibaba.securitysdk.logging.api.configurations.LogConfig;
import com.alibaba.securitysdk.logging.api.factories.ILoggerFactory;
import com.alibaba.securitysdk.logging.api.loggers.SimpleLogger;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleLoggerFactory
implements ILoggerFactory<SimpleLogger> {
    private Map<String, SimpleLogger> loggerMap = new ConcurrentHashMap<String, SimpleLogger>();

    @Override
    public SimpleLogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    @Override
    public SimpleLogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SimpleLogger getLogger(String name, LogConfig logConfig) {
        SimpleLogger simpleLogger = this.loggerMap.get(AssertUtil.notNull((Object)name));
        if (simpleLogger != null) return simpleLogger;
        Class<SimpleLoggerFactory> clazz = SimpleLoggerFactory.class;
        synchronized (SimpleLoggerFactory.class) {
            simpleLogger = this.loggerMap.get(name);
            if (simpleLogger != null) return simpleLogger;
            if (logConfig != null) return new SimpleLogger(name, logConfig);
            return new SimpleLogger(name, "securitysdk.log");
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Class<SimpleLogger> getLoggerClass() {
        return SimpleLogger.class;
    }
}

