/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.loggers;

import com.alibaba.securitysdk.logging.api.Level;
import com.alibaba.securitysdk.logging.api.LogModel;
import com.alibaba.securitysdk.logging.api.SecType;
import com.alibaba.securitysdk.logging.api.configurations.LogConfig;
import com.alibaba.securitysdk.logging.api.exceptions.UnexpectedException;
import com.alibaba.securitysdk.logging.api.loggers.AbstractConfigurableLogger;
import com.alibaba.securitysdk.logging.api.loggers.LeveledLogger;
import com.alibaba.securitysdk.logging.api.loggers.appenders.Appender;
import com.alibaba.securitysdk.logging.api.loggers.appenders.DummyAppender;
import com.alibaba.securitysdk.logging.api.loggers.appenders.FileAppender;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.logging.Logger;

public class SimpleLogger
extends AbstractConfigurableLogger
implements LeveledLogger {
    private static Level rootLevel = Level.INFO;
    private static final Logger LOGGER = Logger.getLogger(SimpleLogger.class.getName());
    private Appender appender;

    public SimpleLogger(String name, LogConfig logConfig) {
        super(name, logConfig);
        try {
            this.appender = new FileAppender(name, logConfig);
        }
        catch (AccessDeniedException ex) {
            LOGGER.warning("Access denied when handling " + logConfig.getFileName());
            this.appender = new DummyAppender(logConfig.getFileName());
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    public SimpleLogger(String name, String fileName) {
        super(name, null);
        try {
            this.appender = new FileAppender(name, fileName);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void log(Level level, String message, Throwable throwable, Object ... args) {
        if (this.isLevelEnabled(level)) {
            this.appender.append(level, message, throwable, args);
        }
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        this.log(level, message, null, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    @Override
    public void error(String message, Throwable throwable, Object ... args) {
        this.log(Level.ERROR, message, throwable, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    @Override
    public void warn(String message, Throwable throwable, Object ... args) {
        this.log(Level.WARN, message, throwable, args);
    }

    @Override
    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    @Override
    public void info(String message, Throwable throwable, Object ... args) {
        this.log(Level.INFO, message, throwable, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    @Override
    public void debug(String message, Throwable throwable, Object ... args) {
        this.log(Level.DEBUG, message, throwable, args);
    }

    @Override
    public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    @Override
    public void trace(String message, Throwable throwable, Object ... args) {
        this.log(Level.TRACE, message, throwable, args);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    @Override
    public void reconfig(LogConfig logConfig) {
    }

    @Override
    public void log(SecType secType, LogModel model) {
        this.log(Level.INFO, model == null ? null : model.getLogInfo(), new Object[0]);
    }

    @Override
    public void log(SecType secType, String msg) {
        this.log(Level.INFO, msg, new Object[0]);
    }

    private boolean isLevelEnabled(Level level) {
        return rootLevel.compareTo(level) <= 0;
    }
}

