/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.binders;

import com.alibaba.securitysdk.logging.api.Logger;
import com.alibaba.securitysdk.logging.api.binders.LoggerFactoryBinder;
import com.alibaba.securitysdk.logging.api.factories.ILoggerFactory;
import com.alibaba.securitysdk.logging.utils.IteratorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public enum LoggerBinderSingleton implements LoggerFactoryBinder
{
    INSTANCE;

    private Map<Class<? extends Logger>, ILoggerFactory<? extends Logger>> boundLoggerFactories;
    private volatile boolean bound = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Logger> ILoggerFactory<T> getLoggerFactory(Class<T> clazz) {
        if (!this.bound) {
            LoggerBinderSingleton loggerBinderSingleton = this;
            synchronized (loggerBinderSingleton) {
                if (!this.bound) {
                    this.performBindingAll();
                    this.bound = true;
                }
            }
        }
        return this.boundLoggerFactories.get(clazz);
    }

    @Override
    public void performBindingAll() {
        this.instantiateBindedLoggerFactories();
        ServiceLoader<ILoggerFactory> loader = ServiceLoader.load(ILoggerFactory.class, ILoggerFactory.class.getClassLoader());
        List iLoggerFactories = IteratorUtils.toList(loader.iterator());
        for (ILoggerFactory loggerFactory : iLoggerFactories) {
            Class loggerClass = loggerFactory.getLoggerClass();
            if (loggerClass == null) continue;
            ILoggerFactory<? extends Logger> candidate = this.boundLoggerFactories.get(loggerClass);
            if (candidate == null) {
                this.boundLoggerFactories.put(loggerClass, loggerFactory);
                continue;
            }
            if (loggerFactory.getOrder() >= candidate.getOrder()) continue;
            this.boundLoggerFactories.put(loggerClass, loggerFactory);
        }
        this.bound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateBindedLoggerFactories() {
        if (this.boundLoggerFactories == null) {
            LoggerBinderSingleton loggerBinderSingleton = this;
            synchronized (loggerBinderSingleton) {
                if (this.boundLoggerFactories == null) {
                    this.boundLoggerFactories = new HashMap<Class<? extends Logger>, ILoggerFactory<? extends Logger>>();
                }
            }
        }
    }

    Map<Class<? extends Logger>, ILoggerFactory<? extends Logger>> getBoundLoggerFactories() {
        return this.boundLoggerFactories;
    }
}

