/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.script;

import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.script.ScriptDiffElement;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptDiffTool {
    private static final Logger log = LoggerFactory.getLogger(ScriptDiffTool.class);

    public ScriptDiffElement diffCount(String baseScript, String novelScript) {
        if (StringUtils.isEmpty((CharSequence)baseScript)) {
            baseScript = "";
        }
        if (StringUtils.isEmpty((CharSequence)novelScript)) {
            novelScript = "";
        }
        Patch<String> patch = this.diffPatch(baseScript, novelScript);
        Integer insertCount = 0;
        Integer deleteCount = 0;
        Integer changeSrcCount = 0;
        Integer changeTgtCount = 0;
        Integer equalCount = 0;
        block6: for (AbstractDelta delta : patch.getDeltas()) {
            switch (delta.getType()) {
                case CHANGE: {
                    Integer n;
                    for (String s : delta.getSource().getLines()) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        n = changeSrcCount;
                        changeSrcCount = changeSrcCount + 1;
                    }
                    for (String s : delta.getTarget().getLines()) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        n = changeTgtCount;
                        changeTgtCount = changeTgtCount + 1;
                    }
                    continue block6;
                }
                case DELETE: {
                    Integer n;
                    for (String s : delta.getSource().getLines()) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        n = deleteCount;
                        deleteCount = deleteCount + 1;
                    }
                    continue block6;
                }
                case INSERT: {
                    Integer n;
                    for (String s : delta.getTarget().getLines()) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        n = insertCount;
                        insertCount = insertCount + 1;
                    }
                    continue block6;
                }
                case EQUAL: {
                    equalCount = equalCount + delta.getSource().size();
                }
            }
        }
        return ScriptDiffElement.builder().addLineCount(insertCount + changeTgtCount).deleteLintCount(deleteCount + changeSrcCount).rawLineCount(equalCount + changeSrcCount + deleteCount).build();
    }

    public Patch<String> diffPatch(String baseScript, String novelScript) {
        if (StringUtils.isEmpty((CharSequence)baseScript)) {
            baseScript = "";
        }
        if (StringUtils.isEmpty((CharSequence)novelScript)) {
            novelScript = "";
        }
        List<String> baseScriptList = Arrays.asList(baseScript.split("\n"));
        List<String> novelScriptList = Arrays.asList(novelScript.split("\n"));
        return DiffUtils.diff(baseScriptList, novelScriptList, (boolean)true);
    }

    public Integer lineCount(String script) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            return 0;
        }
        return script.split("\n").length;
    }
}

